<?php 
session_start();
if (!isset($_SESSION['user_id'])) { header('Location: login.php'); exit; }
require_once 'config/database.php';
$user_id = $_SESSION['user_id'];

try {
    $db = getDB();
    $stmt = $db->prepare("SELECT * FROM yields WHERE user_id = ? ORDER BY created_at DESC");
    $stmt->execute([$user_id]);
    $user_yields = $stmt->fetchAll();
} catch (Exception $e) { $user_yields = []; }

include 'components/header.php'; ?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yield Tarımı - KriptoCum</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/style.css">
    <script src="assets/js/dropdown.js"></script>
</head>
<body class="bg-gray-50">
    <!-- Main Content -->
    <div class="pt-16 min-h-screen">
        <div class="container mx-auto px-4 py-8">
            <!-- Header -->
            <div class="mb-8">
                <h1 class="text-3xl font-bold text-gray-800 mb-2">Yield Tarımı</h1>
                <p class="text-gray-600">DeFi yield farming stratejileri ile getirilerinizi maksimize edin</p>
            </div>

            <!-- Yield Overview -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-600">Toplam Kilitli Değer</p>
                            <p class="text-2xl font-bold text-gray-900" id="totalValueLocked">$0.00</p>
                        </div>
                        <div class="p-3 bg-blue-100 rounded-full">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                            </svg>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-600">Toplam Ödüller</p>
                            <p class="text-2xl font-bold text-green-600" id="totalRewards">$0.00</p>
                        </div>
                        <div class="p-3 bg-green-100 rounded-full">
                            <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                            </svg>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-600">Aktif Havuzlar</p>
                            <p class="text-2xl font-bold text-purple-600" id="activePools">0</p>
                        </div>
                        <div class="p-3 bg-purple-100 rounded-full">
                            <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-600">Ort. APY</p>
                            <p class="text-2xl font-bold text-orange-600" id="averageAPY">0.0%</p>
                        </div>
                        <div class="p-3 bg-orange-100 rounded-full">
                            <svg class="w-6 h-6 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                            </svg>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Yield Pools -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden mb-8">
                <div class="p-6 border-b border-gray-200">
                    <h2 class="text-xl font-bold text-gray-800">Mevcut Yield Havuzları</h2>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Havuz</th>
                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-600 uppercase">APY</th>
                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-600 uppercase">TVL</th>
                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-600 uppercase">Min. Yatırım</th>
                                <th class="px-6 py-3 text-center text-xs font-semibold text-gray-600 uppercase">İşlem</th>
                            </tr>
                        </thead>
                        <tbody id="yieldPoolsTableBody" class="bg-white divide-y divide-gray-200">
                            <!-- Yield pools will be loaded here -->
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- My Yield Positions -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
                <div class="p-6 border-b border-gray-200">
                    <h2 class="text-xl font-bold text-gray-800">Yield Pozisyonlarım</h2>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Pool</th>
                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-600 uppercase">Deposited</th>
                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-600 uppercase">APY</th>
                                <th class="px-6 py-3 text-right text-xs font-semibold text-gray-600 uppercase">Rewards</th>
                                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Status</th>
                                <th class="px-6 py-3 text-center text-xs font-semibold text-gray-600 uppercase">Action</th>
                            </tr>
                        </thead>
                        <tbody id="myYieldTableBody" class="bg-white divide-y divide-gray-200">
                            <!-- My yield positions will be loaded here -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Yield Modal -->
    <div id="yieldModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50">
        <div class="flex items-center justify-center min-h-screen p-4">
            <div class="bg-white rounded-lg max-w-md w-full p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-gray-800">Join <span id="yieldPoolName">BTC-ETH Pool</span></h3>
                    <button onclick="hideYieldModal()" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Amount to Deposit (Token 1)</label>
                        <input type="number" id="depositAmount1" placeholder="0.00" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Amount to Deposit (Token 2)</label>
                        <input type="number" id="depositAmount2" placeholder="0.00" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Token Pair</label>
                        <select id="tokenPair" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="btc-eth">BTC/ETH (50/50)</option>
                            <option value="eth-usdt">ETH/USDT (50/50)</option>
                            <option value="btc-usdt">BTC/USDT (50/50)</option>
                        </select>
                    </div>
                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-3">
                        <p class="text-sm text-blue-800">Expected APY: <span id="expectedAPY">15.2%</span></p>
                    </div>
                    <button onclick="confirmYieldDeposit()" class="w-full bg-blue-600 text-white py-2 rounded-lg hover:bg-blue-700">Deposit Now</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        let yieldPools = [];
        let myYieldPositions = [];
        let cryptoPrices = {};
        const userYieldsFromPHP = <?php echo json_encode($user_yields); ?>;

        async function loadYieldData() {
            try {
                const response = await fetch('assets/crypto_prices.json?t='+Date.now());
                const data = await response.json();
                cryptoPrices = data.prices || {};
                const coins = Object.keys(cryptoPrices);
                yieldPools = [];
                for (let i=0;i<Math.min(coins.length,8);i+=2){
                    const c1 = coins[i]; const c2 = coins[i+1] || coins[0];
                    yieldPools.push({
                        name: `${c1}-${c2} Pool`,
                        pair: `${c1}/${c2}`,
                        apy: (Math.random()*20+5),
                        tvl: `$${(Math.random()*3+0.5).toFixed(1)}M`,
                        minDeposit: `0.01 ${c1} + 0.1 ${c2}`,
                        logo1: (cryptoPrices[c1] && cryptoPrices[c1].image) ? cryptoPrices[c1].image : null,
                        logo2: (cryptoPrices[c2] && cryptoPrices[c2].image) ? cryptoPrices[c2].image : null,
                    });
                }
            } catch(e) { console.error(e); }

            // Map PHP yields to JS model
            myYieldPositions = userYieldsFromPHP.map(y => ({
                id: y.id,
                name: y.pool_name,
                pair: y.token_pair,
                asset1: y.coin_symbol_1,
                asset2: y.coin_symbol_2,
                deposited: `${parseFloat(y.amount_1)} ${y.coin_symbol_1} + ${parseFloat(y.amount_2)} ${y.coin_symbol_2}`,
                apy: parseFloat(y.apy),
                rewards: `${parseFloat(y.rewards_1)} ${y.coin_symbol_1} + ${parseFloat(y.rewards_2)} ${y.coin_symbol_2}`,
                status: y.status === 'active' ? 'Active' : 'Closed',
                logo1: (cryptoPrices[y.coin_symbol_1] && cryptoPrices[y.coin_symbol_1].image) ? cryptoPrices[y.coin_symbol_1].image : null,
                logo2: (cryptoPrices[y.coin_symbol_2] && cryptoPrices[y.coin_symbol_2].image) ? cryptoPrices[y.coin_symbol_2].image : null,
            }));

            updateYieldPoolsTable();
            updateMyYieldTable();
            updateOverview();
        }

        function updateYieldPoolsTable(){
            const tbody = document.getElementById('yieldPoolsTableBody'); tbody.innerHTML='';
            yieldPools.forEach(pool=>{
                const tr = document.createElement('tr'); tr.className='hover:bg-gray-50';
                tr.innerHTML = `
                    <td class="px-6 py-4">
                        <div class="flex items-center gap-3">
                            <div class="flex -space-x-2">
                                <div class="w-8 h-8 rounded-full overflow-hidden bg-gray-100 flex items-center justify-center border-2 border-white">
                                    ${pool.logo1 ? `<img src="${pool.logo1}" alt="Token 1" class="w-6 h-6 object-contain">` : `<div class=\"w-6 h-6 rounded-full bg-gray-200 text-gray-700 text-[10px] font-bold flex items-center justify-center\">${pool.pair.split('/')[0].substring(0,2)}</div>`}
                                </div>
                                <div class="w-8 h-8 rounded-full overflow-hidden bg-gray-100 flex items-center justify-center border-2 border-white">
                                    ${pool.logo2 ? `<img src="${pool.logo2}" alt="Token 2" class="w-6 h-6 object-contain">` : `<div class=\"w-6 h-6 rounded-full bg-gray-200 text-gray-700 text-[10px] font-bold flex items-center justify-center\">${pool.pair.split('/')[1].substring(0,2)}</div>`}
                                </div>
                            </div>
                            <div>
                                <div class="font-semibold text-gray-800">${pool.name}</div>
                                <div class="text-xs text-gray-500">${pool.pair}</div>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 text-right text-green-600 font-semibold">${parseFloat(pool.apy).toFixed(1)}%</td>
                    <td class="px-6 py-4 text-right text-gray-800">${pool.tvl}</td>
                    <td class="px-6 py-4 text-right text-gray-600">${pool.minDeposit}</td>
                    <td class="px-6 py-4 text-center">
                        <button onclick="showYieldModal('${pool.name}', ${pool.apy})" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 text-sm">Join Pool</button>
                    </td>`;
                tbody.appendChild(tr);
            });
        }

        function updateMyYieldTable(){
            const tbody = document.getElementById('myYieldTableBody'); tbody.innerHTML='';
            if (myYieldPositions.length===0){ tbody.innerHTML='<tr><td colspan="6" class="px-6 py-8 text-center text-gray-500">No active yield positions</td></tr>'; return; }
            myYieldPositions.forEach(p=>{
                const tr=document.createElement('tr'); tr.className='hover:bg-gray-50';
                tr.innerHTML=`
                    <td class="px-6 py-4">
                        <div class="flex items-center gap-3">
                            <div class="flex -space-x-2">
                                <div class="w-8 h-8 rounded-full overflow-hidden bg-gray-100 flex items-center justify-center border-2 border-white">
                                    ${p.logo1 ? `<img src="${p.logo1}" class="w-6 h-6 object-contain">` : `<div class=\"w-6 h-6 rounded-full bg-gray-200 text-gray-700 text-[10px] font-bold flex items-center justify-center\">${p.asset1.substring(0,2)}</div>`}
                                </div>
                                <div class="w-8 h-8 rounded-full overflow-hidden bg-gray-100 flex items-center justify-center border-2 border-white">
                                    ${p.logo2 ? `<img src="${p.logo2}" class="w-6 h-6 object-contain">` : `<div class=\"w-6 h-6 rounded-full bg-gray-200 text-gray-700 text-[10px] font-bold flex items-center justify-center\">${p.asset2.substring(0,2)}</div>`}
                                </div>
                            </div>
                            <div>
                                <div class="font-semibold text-gray-800">${p.name}</div>
                                <div class="text-xs text-gray-500">${p.pair}</div>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 text-right text-gray-800 font-mono">${p.deposited}</td>
                    <td class="px-6 py-4 text-right text-green-600 font-semibold">${parseFloat(p.apy).toFixed(1)}%</td>
                    <td class="px-6 py-4 text-right text-green-600 font-semibold">${p.rewards}</td>
                    <td class="px-6 py-4">
                        <span class="px-2 py-1 text-xs font-semibold rounded-full ${p.status==='Active'?'bg-green-100 text-green-800':'bg-gray-100 text-gray-800'}">${p.status}</span>
                    </td>
                    <td class="px-6 py-4 text-center">
                        <div class="flex justify-center gap-2">
                            <button onclick="claimYieldRewards(${p.id})" class="text-green-600 hover:text-green-700 text-sm">Claim</button>
                            <button onclick="withdrawYield(${p.id})" class="text-red-600 hover:text-red-700 text-sm">Withdraw</button>
                        </div>
                    </td>`;
                tbody.appendChild(tr);
            });
        }

        function updateOverview(){
            let tvl=0,rews=0,active=0,totApy=0;
            myYieldPositions.forEach(p=>{
                const [a1,,a2] = [p.deposited.split(' ')[0], null, p.deposited.split('+')[1]?.trim().split(' ')[0]];
                const price1 = cryptoPrices[p.asset1]?.raw_price || 0; const price2 = cryptoPrices[p.asset2]?.raw_price || 0;
                tvl += (parseFloat(a1)||0)*price1 + (parseFloat(a2)||0)*price2;
                // rewards not converted here (string), keep $0.00 placeholder or parse similarly if needed
                totApy += p.apy; active++;
            });
            const avg = active>0 ? totApy/active : 0;
            document.getElementById('totalValueLocked').textContent = `$${tvl.toFixed(2)}`;
            document.getElementById('totalRewards').textContent = `$${rews.toFixed(2)}`;
            document.getElementById('activePools').textContent = active.toString();
            document.getElementById('averageAPY').textContent = `${avg.toFixed(1)}%`;
        }

        function showYieldModal(poolName, apy){
            document.getElementById('yieldPoolName').textContent = poolName;
            document.getElementById('expectedAPY').textContent = `${parseFloat(apy).toFixed(1)}%`;
            document.getElementById('yieldModal').classList.remove('hidden');
        }
        function hideYieldModal(){ document.getElementById('yieldModal').classList.add('hidden'); }

        function confirmYieldDeposit(){
            const poolName = document.getElementById('yieldPoolName').textContent;
            const pair = document.getElementById('tokenPair').value; // e.g., btc-eth
            const [coin1, coin2] = pair.split('-').map(s=>s.toUpperCase());
            const amount1 = document.getElementById('depositAmount1').value;
            const amount2 = document.getElementById('depositAmount2').value;
            const apy = parseFloat(document.getElementById('expectedAPY').textContent.replace('%',''));
            if (!amount1 || !amount2 || amount1<=0 || amount2<=0){ alert('Lütfen geçerli miktarlar girin'); return; }
            const fd = new FormData();
            fd.append('pool_name', poolName);
            fd.append('token_pair', coin1+'/'+coin2);
            fd.append('coin1', coin1); fd.append('coin2', coin2);
            fd.append('amount1', amount1); fd.append('amount2', amount2);
            fd.append('apy', apy);
            fetch('api/process_yield_deposit.php',{method:'POST',body:fd}).then(r=>r.json()).then(d=>{
                if(d.success){ alert(d.message); hideYieldModal(); location.reload(); } else { alert('Hata: '+d.message); }
            }).catch(()=>alert('Bir hata oluştu!'));
        }
        function claimYieldRewards(yieldId){
            const fd = new FormData(); fd.append('yield_id', yieldId);
            fetch('api/process_yield_claim.php',{method:'POST',body:fd}).then(r=>r.json()).then(d=>{
                if(d.success){ alert(d.message); location.reload(); } else { alert('Hata: '+d.message); }
            }).catch(()=>alert('Bir hata oluştu!'));
        }
        function withdrawYield(yieldId){
            if(!confirm('Pozisyondan çıkmak istiyor musunuz?')) return;
            const fd = new FormData(); fd.append('yield_id', yieldId);
            fetch('api/process_yield_withdraw.php',{method:'POST',body:fd}).then(r=>r.json()).then(d=>{
                if(d.success){ alert(d.message); location.reload(); } else { alert('Hata: '+d.message); }
            }).catch(()=>alert('Bir hata oluştu!'));
        }

        document.addEventListener('DOMContentLoaded', loadYieldData);
    </script>

    <?php include 'components/footer.php'; ?>
</body>
</html>
