<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

require_once 'config/database.php';

$user_id = $_SESSION['user_id'];

// Kullanıcının cüzdan verilerini veritabanından çek
try {
    $db = getDB();
    $stmt = $db->prepare("SELECT * FROM wallets WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $wallets = $stmt->fetchAll();
    
    // USDT bakiyesini kontrol et
    $usdt_balance = 0;
    $current_coin = 'BTC';
    $current_coin_balance = 0;
    
    foreach ($wallets as $wallet) {
        if ($wallet['coin_symbol'] === 'USDT') {
            $usdt_balance = floatval($wallet['available']);
        }
        if ($wallet['coin_symbol'] === $current_coin) {
            $current_coin_balance = floatval($wallet['available']);
        }
    }
} catch (Exception $e) {
    $wallets = [];
    $usdt_balance = 0;
    $current_coin_balance = 0;
}

// Seçilen coin'i al (varsa)
if (isset($_GET['symbol'])) {
    $current_coin = $_GET['symbol'];
    foreach ($wallets as $wallet) {
        if ($wallet['coin_symbol'] === $current_coin) {
            $current_coin_balance = floatval($wallet['available']);
        }
    }
}

include 'components/header.php';
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Spot İşlem - Kriptocum</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="assets/style.css">
    <script src="assets/js/dropdown.js"></script>
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
</head>
<body class="bg-gray-50">
    
    <main class="pt-16">
        <!-- Trading Interface - TradingView Tarzı -->
        <div class="grid grid-cols-12 gap-0 min-h-[calc(100vh-4rem)]">
            
            <!-- Sol Sidebar - Trading Pairs -->
            <div class="col-span-12 lg:col-span-2 bg-white border-r border-gray-200 overflow-y-auto max-h-[calc(100vh-4rem)]">
                <!-- Search Box -->
                <div class="p-3 border-b border-gray-200 sticky top-0 bg-white">
                    <input type="text" placeholder="🔍 Çift ara..." class="w-full px-3 py-2 text-sm border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 bg-gray-50">
                </div>
                
                <!-- Market Stats -->
                <div class="p-3 border-b border-gray-200">
                    <div class="text-xs font-medium text-gray-600 mb-2">Favoriler</div>
                    <div class="space-y-1">
                        <div class="flex items-center justify-between p-2 rounded hover:bg-gray-50 cursor-pointer">
                            <span class="text-sm font-semibold text-gray-700">⭐ BTC/USDT</span>
                            <span class="text-xs text-green-600 font-semibold">+2.34%</span>
                        </div>
                    </div>
                </div>
                
                <!-- Trading Pairs -->
                <div class="p-3">
                    <div class="text-xs font-medium text-gray-600 mb-2">Alışlar (USDT)</div>
                    <div class="space-y-0.5" id="cryptoList">
                        <!-- Fiyatlar otomatik olarak yüklenecek -->
                    </div>
                </div>
            </div>
            
            <!-- Ana İçerik Alanı -->
            <div class="col-span-12 lg:col-span-10 flex flex-col">

                <!-- Mobile Markets Toolbar -->
                <div class="md:hidden bg-white border-b border-gray-200 sticky top-16 z-10">
                    <div class="p-3">
                        <input type="text" placeholder="🔍 Çift ara..." class="w-full px-3 py-2 text-sm border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 bg-gray-50">
                    </div>
                    <div class="px-2 pb-2">
                        <div class="flex gap-2 overflow-x-auto no-scrollbar" id="cryptoListMobile"></div>
                    </div>
                </div>
                
                <!-- Chart Header -->
                <div class="bg-white border-b border-gray-200 px-3 md:px-4 py-2 md:py-3 flex items-center justify-between sticky top-[88px] md:static z-10">
                    <div class="flex items-center gap-3 md:gap-4">
                        <div>
                            <h2 class="text-lg md:text-xl font-bold text-gray-800">BTC/USDT</h2>
                            <div class="text-xs md:text-sm text-gray-600">$43,250.50 <span class="text-green-600 font-semibold">+2.34%</span></div>
                        </div>
                        <div class="hidden md:flex items-center gap-1 text-xs">
                            <span class="px-2 py-1 bg-gray-100 text-gray-600 rounded">24h: <span class="font-semibold">$43,250</span> - <span class="font-semibold">$42,800</span></span>
                            <span class="px-2 py-1 bg-gray-100 text-gray-600 rounded">Vol: <span class="font-semibold">$1.2B</span></span>
                        </div>
                    </div>
                    
                    <!-- Chart Tools -->
                    <div class="flex items-center gap-2">
                        <div class="flex gap-1 bg-gray-100 rounded p-1 overflow-x-auto no-scrollbar">
                            <button class="px-2 md:px-3 py-1 text-xs md:text-sm font-semibold bg-white text-gray-800 rounded shadow-sm">1m</button>
                            <button class="px-2 md:px-3 py-1 text-xs md:text-sm text-gray-600 hover:text-gray-800">5m</button>
                            <button class="px-2 md:px-3 py-1 text-xs md:text-sm text-gray-600 hover:text-gray-800">15m</button>
                            <button class="px-2 md:px-3 py-1 text-xs md:text-sm text-gray-600 hover:text-gray-800">1H</button>
                            <button class="px-2 md:px-3 py-1 text-xs md:text-sm text-blue-600 font-semibold">1D</button>
                            <button class="px-2 md:px-3 py-1 text-xs md:text-sm text-gray-600 hover:text-gray-800">1W</button>
                            <button class="px-2 md:px-3 py-1 text-xs md:text-sm text-gray-600 hover:text-gray-800">1M</button>
                        </div>
                    </div>
                </div>
                
                <!-- Chart Area -->
                <div class="flex-1 bg-white relative min-h-[65vh] md:min-h-[70vh] lg:min-h-[75vh]" style="z-index: 1; overflow: visible;">
                    <!-- TradingView Widget -->
                    <div class="tradingview-widget-container h-full w-full" style="z-index: 1; overflow: visible;">
                        <div id="tradingview_chart" class="h-full w-full" style="z-index: 1; overflow: visible;"></div>
                    </div>
                    
                    <!-- TradingView Copyright - Bottom Right -->
                    <div class="absolute bottom-2 right-2 z-10">
                        <div class="bg-white/90 backdrop-blur-sm px-2 py-1 rounded text-xs text-gray-500 shadow-sm">
                            <a href="https://tr.tradingview.com/" rel="noopener nofollow" target="_blank" class="text-blue-600 hover:text-blue-700 font-medium">
                                TradingView
                            </a> tarafından
                        </div>
                    </div>
                </div>
                
                <!-- Bottom Section - Order Book, Trades, Order Form -->
                <div class="grid grid-cols-12 gap-0 border-t border-gray-200 bg-white">
                    
                    <!-- Order Book (Alış/Satış Emirleri) -->
                    <div class="col-span-12 lg:col-span-3 border-r border-gray-200">
                        <div class="p-3 border-b border-gray-200 sticky top-[56px] md:top-[88px] bg-white z-10">
                            <div class="flex items-center justify-between">
                                <div class="text-sm font-semibold text-gray-700">Emir Defteri</div>
                                <div class="text-xs text-gray-500">Spread: <span class="font-semibold text-gray-700" id="spreadValue">0.00%</span></div>
                            </div>
                        </div>
                        <div class="overflow-y-auto max-h-[38vh] md:max-h-[300px]">
                            <!-- Satış Emirleri (Asks) -->
                            <div class="p-3 space-y-0.5">
                                <div class="text-xs text-gray-500 mb-1 px-2">Satış</div>
                                <div class="text-xs text-right space-y-0.5" id="asksList">
                                    <!-- Gerçek veriler yüklenecek -->
                                </div>
                            </div>
                            
                            <!-- Current Price -->
                            <div class="p-3 bg-blue-50 border-y border-blue-200">
                                <div class="text-center">
                                    <div class="text-xs text-gray-600">Fiyat</div>
                                    <div id="currentPrice" class="text-xl font-bold text-gray-800 mt-1">43,250.50</div>
                                    <div id="currentChange" class="text-xs text-green-600 font-semibold">+2.34%</div>
                                </div>
                            </div>
                            
                            <!-- Alış Emirleri (Bids) -->
                            <div class="p-3 space-y-0.5">
                                <div class="text-xs text-gray-500 mb-1 px-2">Alış</div>
                                <div class="text-xs space-y-0.5" id="bidsList">
                                    <!-- Gerçek veriler yüklenecek -->
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Recent Trades (Son İşlemler) -->
                    <div class="col-span-12 lg:col-span-3 border-r border-gray-200">
                        <div class="p-3 border-b border-gray-200 sticky top-[56px] md:top-[88px] bg-white z-10">
                            <div class="text-sm font-semibold text-gray-700">Son İşlemler</div>
                        </div>
                        <div class="overflow-y-auto max-h-[38vh] md:max-h-[300px]">
                            <div class="p-3 space-y-1" id="tradesList">
                                <!-- Gerçek veriler yüklenecek -->
                            </div>
                        </div>
                    </div>
                    
                    <!-- Order Form (Alış/Satış Formu) -->
                    <div class="col-span-12 lg:col-span-6">
                        <div class="flex border-b border-gray-200">
                            <button onclick="setOrderType('buy')" id="buyBtn" class="flex-1 px-4 py-3 font-semibold text-white bg-green-600 hover:bg-green-700 transition-colors">
                                AL (Limit)
                            </button>
                            <button onclick="setOrderType('sell')" id="sellBtn" class="flex-1 px-4 py-3 font-semibold text-gray-600 hover:bg-gray-50 transition-colors bg-gray-100">
                                SAT (Limit)
                            </button>
                            <button class="px-3 py-3 text-gray-400 hover:text-gray-600 hover:bg-gray-50">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="12" cy="12" r="10"></circle>
                                    <line x1="12" y1="16" x2="12" y2="12"></line>
                                    <line x1="12" y1="8" x2="12.01" y2="8"></line>
                                </svg>
                            </button>
                        </div>
                        
                        <div class="p-3 md:p-4 space-y-4">
                            <!-- Price Input -->
                            <div>
                                <div class="flex items-center justify-between mb-2">
                                    <label class="text-sm font-medium text-gray-700">Fiyat</label>
                                    <button onclick="setMarketPrice()" class="text-xs text-blue-600 hover:text-blue-700">Piyasa fiyatı</button>
                                </div>
                                <input type="text" id="priceInput" value="" oninput="calculateTotal()" class="w-full px-3 md:px-4 py-2 text-sm border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent">
                            </div>
                            
                            <!-- Amount Input -->
                            <div>
                                <div class="flex items-center justify-between mb-2">
                                    <label class="text-sm font-medium text-gray-700">Miktar</label>
                                    <div class="flex gap-1">
                                        <button onclick="setPercentage(25)" class="text-xs text-blue-600 hover:text-blue-700 px-1">%25</button>
                                        <button onclick="setPercentage(50)" class="text-xs text-blue-600 hover:text-blue-700 px-1">%50</button>
                                        <button onclick="setPercentage(75)" class="text-xs text-blue-600 hover:text-blue-700 px-1">%75</button>
                                        <button onclick="setPercentage(100)" class="text-xs text-blue-600 hover:text-blue-700 px-1">%100</button>
                                    </div>
                                </div>
                                <input type="text" id="amountInput" placeholder="0.00" oninput="calculateTotal()" class="w-full px-3 md:px-4 py-2 text-sm border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent">
                            </div>
                            
                            <!-- Total -->
                            <div class="relative">
                                <input type="text" id="totalInput" placeholder="≈ $0.00" readonly class="w-full px-3 md:px-4 py-2 text-sm border-2 border-gray-200 rounded-lg bg-gray-50 text-gray-600">
                                <span class="absolute right-3 top-2.5 text-xs text-gray-500">USDT</span>
                            </div>
                            
                            <!-- Buttons -->
                            <div class="flex gap-2 pt-2">
                                <button id="orderBtn" onclick="placeOrder()" class="flex-1 bg-green-600 hover:bg-green-700 text-white py-3 rounded-lg font-semibold transition-colors">
                                    <span id="orderBtnText">BTC Al</span>
                                </button>
                            </div>
                            
                            <!-- Balance Info -->
                            <div class="pt-3 border-t border-gray-200">
                                <div class="flex justify-between text-xs text-gray-600 mb-1">
                                    <span>Müsait</span>
                                    <span class="font-semibold text-gray-800" id="availableBalance">0.00 USDT</span>
                                </div>
                                <div class="flex justify-between text-xs text-gray-600">
                                    <span>Verilen Toplam</span>
                                    <span class="font-semibold text-gray-800" id="totalFrozen">0.00 USDT</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
                
            </div>
            
        </div>
    </main>
    
    <!-- TradingView Widget Script -->
    <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
    <script type="text/javascript">
        window.tvWidget = new TradingView.widget({
            "autosize": true,
            "symbol": "BINANCE:BTCUSDT",
            "interval": "1D",
            "timezone": "Europe/Istanbul",
            "theme": "light",
            "style": "1",
            "locale": "tr",
            "toolbar_bg": "#f1f3f6",
            "enable_publishing": false,
            "hide_top_toolbar": false,
            "hide_legend": false,
            "save_image": false,
            "container_id": "tradingview_chart",
            "studies": [
                "RSI@tv-basicstudies",
                "MACD@tv-basicstudies"
            ],
            "show_popup_button": true,
            "popup_width": "1000",
            "popup_height": "650",
            "no_referral_id": true,
            "referral_id": "kriptocum"
        });
    </script>

    <script>
        // Global state - PHP'den gelen veriler
        let currentSymbol = '<?php echo $current_coin; ?>';
        let currentOrderType = 'buy';
        let currentPrice = 0;
        
        // Gerçek bakiye verileri
        let usdtBalance = <?php echo $usdt_balance; ?>;
        let currentCoinBalance = <?php echo $current_coin_balance; ?>;
        let availableBalance = <?php echo $usdt_balance; ?>;
        
        // PHP'den gelen cüzdan verileri
        const walletsData = <?php echo json_encode($wallets); ?>;
        
        // Seçilen coin değiştiğinde bakiyeyi güncelle
        function updateBalance(symbol) {
            currentSymbol = symbol;
            
            // Yeni seçilen coin için bakiyeyi bul
            const wallet = walletsData.find(w => w.coin_symbol === symbol);
            if (wallet) {
                currentCoinBalance = parseFloat(wallet.available);
            } else {
                currentCoinBalance = 0;
            }
            
            // Order type'a göre mevcut bakiyeyi güncelle
            if (currentOrderType === 'buy') {
                availableBalance = usdtBalance;
            } else {
                availableBalance = currentCoinBalance;
            }
            
            // Bakiye bilgisini güncelle
            updateBalanceDisplay();
        }
        
        // Bakiye görüntüsünü güncelle
        function updateBalanceDisplay() {
            if (currentOrderType === 'buy') {
                availableBalance = usdtBalance;
                document.getElementById('availableBalance').textContent = usdtBalance.toFixed(2) + ' USDT';
            } else {
                availableBalance = currentCoinBalance;
                document.getElementById('availableBalance').textContent = currentCoinBalance.toFixed(8) + ' ' + currentSymbol;
            }
        }
        
        function setOrderType(type) {
            const buyBtn = document.getElementById('buyBtn');
            const sellBtn = document.getElementById('sellBtn');
            const orderBtn = document.getElementById('orderBtn');
            const orderBtnText = document.getElementById('orderBtnText');
            
            currentOrderType = type;
            
            // Bakiyeyi güncelle
            if (type === 'buy') {
                availableBalance = usdtBalance;
            } else {
                availableBalance = currentCoinBalance;
            }
            
            if (type === 'buy') {
                buyBtn.classList.remove('bg-gray-100', 'text-gray-600');
                buyBtn.classList.add('bg-green-600', 'text-white');
                sellBtn.classList.remove('bg-red-600', 'text-white');
                sellBtn.classList.add('bg-gray-100', 'text-gray-600', 'hover:bg-gray-50');
                orderBtnText.textContent = `${currentSymbol} Al`;
                orderBtn.classList.remove('bg-red-600', 'hover:bg-red-700');
                orderBtn.classList.add('bg-green-600', 'hover:bg-green-700');
            } else {
                sellBtn.classList.remove('bg-gray-100', 'text-gray-600');
                sellBtn.classList.add('bg-red-600', 'text-white');
                buyBtn.classList.remove('bg-green-600', 'text-white');
                buyBtn.classList.add('bg-gray-100', 'text-gray-600', 'hover:bg-gray-50');
                orderBtnText.textContent = `${currentSymbol} Sat`;
                orderBtn.classList.remove('bg-green-600', 'hover:bg-green-700');
                orderBtn.classList.add('bg-red-600', 'hover:bg-red-700');
            }
            
            // Bakiye görüntüsünü güncelle
            updateBalanceDisplay();
        }
        
        function setMarketPrice() {
            document.getElementById('priceInput').value = currentPrice.toFixed(8);
            calculateTotal();
        }
        
        function setPercentage(percent) {
            const price = parseFloat(document.getElementById('priceInput').value) || currentPrice;
            
            if (currentOrderType === 'buy') {
                // Alış için USDT bakiyesi kullan
                const amount = (availableBalance * percent / 100) / price;
                document.getElementById('amountInput').value = amount.toFixed(8);
            } else {
                // Satış için coin bakiyesi kullan
                const amount = (availableBalance * percent / 100);
                document.getElementById('amountInput').value = amount.toFixed(8);
            }
            
            calculateTotal();
        }
        
        function calculateTotal() {
            const price = parseFloat(document.getElementById('priceInput').value.replace(/,/g, '')) || 0;
            const amount = parseFloat(document.getElementById('amountInput').value.replace(/,/g, '')) || 0;
            const total = price * amount;
            document.getElementById('totalInput').value = `≈ $${total.toFixed(2)}`;
        }
        
        async function placeOrder() {
            const price = parseFloat(document.getElementById('priceInput').value.replace(/,/g, '')) || 0;
            const amount = parseFloat(document.getElementById('amountInput').value.replace(/,/g, '')) || 0;
            
            if (price <= 0 || amount <= 0) {
                alert('Fiyat ve miktar girmelisiniz!');
                return;
            }
            
            // Bakiye kontrolü
            if (currentOrderType === 'buy') {
                const total = price * amount;
                if (total > availableBalance) {
                    alert(`Yetersiz USDT bakiyesi! Mevcut: ${availableBalance.toFixed(2)} USDT, Gerekli: ${total.toFixed(2)} USDT`);
                    return;
                }
            } else {
                if (amount > availableBalance) {
                    alert(`Yetersiz ${currentSymbol} bakiyesi! Mevcut: ${availableBalance.toFixed(8)} ${currentSymbol}, Gerekli: ${amount.toFixed(8)} ${currentSymbol}`);
                    return;
                }
            }
            
            try {
                // Debug: İşlem öncesi currentSymbol değerini kontrol et
                console.log(`İşlem yapılıyor: ${currentOrderType} ${currentSymbol} - Miktar: ${amount} - Fiyat: ${price}`);
                
                const response = await fetch('process_trade.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        order_type: currentOrderType,
                        symbol: currentSymbol,
                        price: price,
                        amount: amount
                    })
                });
                
                const data = await response.json();
                
                if (data.success) {
                    alert(`${currentOrderType === 'buy' ? 'Alış' : 'Satış'} işlemi başarıyla gerçekleştirildi: ${amount} ${currentSymbol} @ $${price.toFixed(8)}`);
                    
                    // Bakiyeleri güncelle
                    updateBalancesAfterTrade(currentOrderType, currentSymbol, amount, price);
                } else {
                    alert(data.message || 'İşlem gerçekleştirilemedi!');
                }
            } catch (error) {
                console.error('Trade error:', error);
                alert('İşlem gerçekleştirilirken bir hata oluştu!');
            }
        }
        
        function updateCurrentCoinBalance(coinSymbol) {
            // PHP'den gelen wallet verilerinden coin bakiyesini bul
            if (typeof walletsData !== 'undefined') {
                for (let wallet of walletsData) {
                    if (wallet.coin_symbol === coinSymbol) {
                        currentCoinBalance = parseFloat(wallet.available);
                        break;
                    }
                }
            }
            
            // Eğer SAT modundaysak availableBalance'i güncelle
            if (currentOrderType === 'sell') {
                availableBalance = currentCoinBalance;
            }
        }
        
        function updateBalancesAfterTrade(orderType, symbol, amount, price) {
            if (orderType === 'buy') {
                // ALIŞ: USDT azaldı, coin arttı
                const totalCost = price * amount;
                usdtBalance -= totalCost;
                
                // walletsData'da coin bakiyesini güncelle
                let coinWallet = walletsData.find(w => w.coin_symbol === symbol);
                if (coinWallet) {
                    coinWallet.available = (parseFloat(coinWallet.available) + amount).toString();
                } else {
                    // Yeni coin wallet oluştur
                    walletsData.push({
                        coin_symbol: symbol,
                        available: amount.toString(),
                        balance: amount.toString(),
                        frozen: '0'
                    });
                }
                
                // USDT bakiyesini güncelle
                const usdtWallet = walletsData.find(w => w.coin_symbol === 'USDT');
                if (usdtWallet) {
                    usdtWallet.available = (parseFloat(usdtWallet.available) - totalCost).toString();
                }
                
                // Mevcut coin bakiyesini güncelle (sadece seçili coin ise)
                if (symbol === currentSymbol) {
                    currentCoinBalance = parseFloat(coinWallet ? coinWallet.available : amount);
                }
                
            } else {
                // SATIŞ: coin azaldı, USDT arttı
                const totalRevenue = price * amount;
                usdtBalance += totalRevenue;
                
                // walletsData'da coin bakiyesini güncelle
                const coinWallet = walletsData.find(w => w.coin_symbol === symbol);
                if (coinWallet) {
                    coinWallet.available = (parseFloat(coinWallet.available) - amount).toString();
                }
                
                // USDT bakiyesini güncelle
                const usdtWallet = walletsData.find(w => w.coin_symbol === 'USDT');
                if (usdtWallet) {
                    usdtWallet.available = (parseFloat(usdtWallet.available) + totalRevenue).toString();
                } else {
                    // USDT wallet oluştur
                    walletsData.push({
                        coin_symbol: 'USDT',
                        available: totalRevenue.toString(),
                        balance: totalRevenue.toString(),
                        frozen: '0'
                    });
                }
                
                // Mevcut coin bakiyesini güncelle
                if (symbol === currentSymbol) {
                    currentCoinBalance = parseFloat(coinWallet ? coinWallet.available : 0);
                }
            }
            
            // Bakiye görüntüsünü güncelle
            updateBalanceDisplay();
            
            // Portfolio ve Wallet sayfalarına bildirim gönder (eğer açıksa)
            if (window.opener) {
                if (window.opener.location.pathname.includes('portfolio.php')) {
                    window.opener.location.reload();
                }
                if (window.opener.location.pathname.includes('wallet.php')) {
                    // Wallet sayfasına bildirim gönder
                    console.log('Wallet sayfasına bildirim gönderiliyor...');
                    window.opener.postMessage({ type: 'WALLET_UPDATE' }, '*');
                }
            }
            
            // Debug: İşlem detaylarını konsola yazdır
            console.log(`İşlem tamamlandı: ${orderType} ${symbol} - Miktar: ${amount} - Fiyat: ${price}`);
        }

        // Load real trading data from Binance
        async function loadTradingData(coinSymbol) {
            try {
                const symbol = `${coinSymbol}USDT`;
                const response = await fetch(`get_trading_data.php?symbol=${symbol}&type=all`);
                const data = await response.json();
                
                if (data.price) {
                    currentPrice = data.price.lastPrice;
                    currentSymbol = coinSymbol;
                    document.getElementById('priceInput').value = currentPrice.toFixed(8);
                    
                    // Coin bakiyesini güncelle
                    updateCurrentCoinBalance(coinSymbol);
                    
                    // Update header
                    const headerTitle = document.querySelector('.text-xl.font-bold.text-gray-800');
                    if (headerTitle) {
                        headerTitle.textContent = `${coinSymbol}/USDT`;
                    }
                    
                    const headerPrice = document.querySelector('.text-sm.text-gray-600');
                    if (headerPrice) {
                        const changeColor = data.price.priceChangePercent >= 0 ? 'green' : 'red';
                        const sign = data.price.priceChangePercent >= 0 ? '+' : '';
                        headerPrice.innerHTML = `$${data.price.lastPrice.toFixed(2)} <span class="text-${changeColor}-600 font-semibold">${sign}${data.price.priceChangePercent.toFixed(2)}%</span>`;
                    }
                    
                    // Update current price display
                    document.getElementById('currentPrice').textContent = currentPrice.toFixed(2);
                    const changeColor = data.price.priceChangePercent >= 0 ? 'green' : 'red';
                    document.getElementById('currentChange').className = `text-xs text-${changeColor}-600 font-semibold`;
                    document.getElementById('currentChange').textContent = `${data.price.priceChangePercent >= 0 ? '+' : ''}${data.price.priceChangePercent.toFixed(2)}%`;
                }
                
                if (data.orderbook) {
                    updateOrderBook(data.orderbook);
                }
                
                if (data.trades) {
                    updateRecentTrades(data.trades);
                }
                
                calculateTotal();
                
                // Bakiye görüntüsünü güncelle
                updateBalanceDisplay();
            } catch (error) {
                console.error('Trading data yüklenemedi:', error);
            }
        }
        
        // Update Order Book display
        function updateOrderBook(orderbook) {
            const asksList = document.getElementById('asksList');
            const bidsList = document.getElementById('bidsList');
            
            // Clear existing
            asksList.innerHTML = '';
            bidsList.innerHTML = '';
            
            // Update asks (satış emirleri - kırmızı)
            orderbook.asks.slice(0, 10).forEach(ask => {
                const price = parseFloat(ask[0]);
                const qty = parseFloat(ask[1]);
                const div = document.createElement('div');
                div.className = 'flex items-center justify-between px-2 py-0.5 hover:bg-red-50 cursor-pointer';
                div.innerHTML = `<span class="text-gray-600">${price.toFixed(8)}</span><span class="text-red-600 font-semibold">${qty.toFixed(4)}</span>`;
                div.onclick = () => document.getElementById('priceInput').value = price;
                asksList.appendChild(div);
            });
            
            // Update bids (alış emirleri - yeşil)
            orderbook.bids.slice(0, 10).forEach(bid => {
                const price = parseFloat(bid[0]);
                const qty = parseFloat(bid[1]);
                const div = document.createElement('div');
                div.className = 'flex items-center justify-between px-2 py-0.5 hover:bg-green-50 cursor-pointer';
                div.innerHTML = `<span class="text-green-600 font-semibold">${qty.toFixed(4)}</span><span class="text-gray-600">${price.toFixed(8)}</span>`;
                div.onclick = () => document.getElementById('priceInput').value = price;
                bidsList.appendChild(div);
            });
            
            // Calculate spread
            if (orderbook.asks.length > 0 && orderbook.bids.length > 0) {
                const bestAsk = parseFloat(orderbook.asks[0][0]);
                const bestBid = parseFloat(orderbook.bids[0][0]);
                const spread = ((bestAsk - bestBid) / bestAsk) * 100;
                document.getElementById('spreadValue').textContent = spread.toFixed(4) + '%';
            }
        }
        
        // Update Recent Trades display
        function updateRecentTrades(trades) {
            const tradesList = document.getElementById('tradesList');
            tradesList.innerHTML = '';
            
            trades.slice(0, 15).forEach(trade => {
                const price = trade.price;
                const qty = trade.qty;
                const time = new Date(trade.time);
                const isBuy = !trade.isBuyer; // Binance API'de isBuyerMaker ters mantık
                const color = isBuy ? 'text-green-600' : 'text-red-600';
                const timeStr = time.toLocaleTimeString('tr-TR', { hour: '2-digit', minute: '2-digit', second: '2-digit' });
                
                const div = document.createElement('div');
                div.className = 'flex items-center justify-between text-xs';
                div.innerHTML = `<span class="${color}">${price.toFixed(8)}</span><span class="text-gray-600">${qty.toFixed(4)}</span><span class="text-gray-400">${timeStr}</span>`;
                tradesList.appendChild(div);
            });
        }
        
        // Trading pair selection
        function selectTradingPair(symbol) {
            console.log('Coin seçildi:', symbol);
            
            // Destroy existing widget and create new one
            if (window.tvWidget) {
                try {
                    if (window.tvWidget.setSymbol) {
                        window.tvWidget.setSymbol(symbol, '1D');
                        console.log('Chart güncellendi:', symbol);
                    } else {
                        console.log('setSymbol metodu yok, widget yeniden oluşturuluyor...');
                        window.tvWidget.remove();
                        
                        window.tvWidget = new TradingView.widget({
                            "autosize": true,
                            "symbol": symbol,
                            "interval": "1D",
                            "timezone": "Europe/Istanbul",
                            "theme": "light",
                            "style": "1",
                            "locale": "tr",
                            "toolbar_bg": "#f1f3f6",
                            "enable_publishing": false,
                            "hide_top_toolbar": false,
                            "hide_legend": false,
                            "save_image": false,
                            "container_id": "tradingview_chart",
                            "studies": ["RSI@tv-basicstudies", "MACD@tv-basicstudies"],
                            "show_popup_button": true,
                            "popup_width": "1000",
                            "popup_height": "650",
                            "no_referral_id": true,
                            "referral_id": "kriptocum"
                        });
                        console.log('Yeni widget oluşturuldu:', symbol);
                    }
                } catch (e) {
                    console.error('Chart güncellenemedi:', e);
                }
            }
            
            // Extract coin symbol from BINANCE:BTCUSDT format
            const coinSymbol = symbol.split(':')[1].replace('USDT', '');
            currentSymbol = coinSymbol;
            
            // Load trading data
            loadTradingData(coinSymbol);
            
            // Update button text
            const orderBtnText = document.getElementById('orderBtnText');
            if (orderBtnText) {
                orderBtnText.textContent = `${currentOrderType === 'buy' ? coinSymbol + ' Al' : coinSymbol + ' Sat'}`;
            }
        }

        // Load crypto prices from JSON file
        async function loadCryptoPrices() {
            try {
                const response = await fetch('assets/crypto_prices.json?t=' + Date.now());
                const data = await response.json();
                
                if (data && data.prices) {
                    const cryptoList = document.getElementById('cryptoList');
                    const cryptoListMobile = document.getElementById('cryptoListMobile');
                    if (cryptoList) cryptoList.innerHTML = '';
                    if (cryptoListMobile) cryptoListMobile.innerHTML = '';
                    
                    // Dış görsel fallback kullanma; yalnızca mevcut image alanı varsa göster
                    
                    let first = true;
                    for (const [symbol, priceData] of Object.entries(data.prices)) {
                        const changeColor = parseFloat(priceData.raw_change) >= 0 ? 'green' : 'red';
                        const changeSign = parseFloat(priceData.raw_change) >= 0 ? '+' : '';
                        const borderClass = first ? 'border-l-4 border-blue-600 bg-blue-50/50' : '';
                        const isActive = first ? 'border-l-4 border-blue-600 bg-blue-50/50' : 'hover:bg-gray-50';
                        const hasImage = priceData.image && priceData.image.trim() !== '';
                        const badge = `<div class=\"w-5 h-5 rounded-full bg-gray-200 text-gray-700 text-[10px] font-bold flex items-center justify-center\">${symbol.substring(0,2)}</div>`;
                        const logoHtml = hasImage ? `<img src=\"${priceData.image}\" alt=\"${symbol}\" class=\"w-5 h-5 object-contain\">` : badge;
                        
                        const itemHtml = `
                            <div class="p-2 rounded cursor-pointer ${isActive}" data-coin="${symbol}" data-symbol="BINANCE:${symbol}USDT">
                                <div class="flex items-center gap-2 mb-1">
                                    <div class=\"w-6 h-6 rounded-full overflow-hidden bg-gray-100 flex items-center justify-center\">${logoHtml}</div>
                                    <span class="text-sm font-semibold">${symbol}</span>
                                    <span class="text-xs text-${changeColor}-600 font-semibold ml-auto">${changeSign}${priceData.change}%</span>
                                </div>
                                <div class="flex items-center justify-between text-xs">
                                    <span class="text-gray-500">$${priceData.price}</span>
                                    <span class="text-gray-400">Vol: ${priceData.volume}</span>
                                </div>
                            </div>
                        `;
                        if (cryptoList) cryptoList.innerHTML += itemHtml;
                        if (cryptoListMobile) cryptoListMobile.innerHTML += itemHtml;
                        first = false;
                    }
                    
                    // Add click events to dynamically loaded elements
                    document.querySelectorAll('[data-coin]').forEach(pair => {
                        pair.addEventListener('click', function() {
                            const symbol = this.getAttribute('data-symbol');
                            selectTradingPair(symbol);
                            
                            // Remove active class from all
                            document.querySelectorAll('[data-coin]').forEach(el => {
                                el.classList.remove('border-l-4', 'border-blue-600', 'bg-blue-50/50');
                                el.classList.add('hover:bg-gray-50');
                            });
                            
                            // Add active class to clicked element
                            this.classList.add('border-l-4', 'border-blue-600', 'bg-blue-50/50');
                            this.classList.remove('hover:bg-gray-50');
                        });
                    });
                }
            } catch (error) {
                console.error('Fiyatlar yüklenemedi:', error);
            }
        }
        
        // Auto-refresh prices every 30 seconds
        function startPriceUpdates() {
            setInterval(loadCryptoPrices, 30000); // 30 saniyede bir
        }
        
        // Start auto-update trading data
        function startTradingDataUpdates(coinSymbol) {
            setInterval(() => {
                loadTradingData(coinSymbol);
            }, 5000); // Her 5 saniyede bir güncelle
        }
        
        // Add click events to trading pairs
        document.addEventListener('DOMContentLoaded', function() {
            loadCryptoPrices(); // İlk yükleme
            startPriceUpdates(); // Otomatik güncelleme başlat
            
            // İlk verilerini yükle
            setTimeout(() => {
                if (!currentSymbol) {
                    currentSymbol = 'BTC';
                }
                loadTradingData(currentSymbol);
                
                // Balance gösterimi - PHP'den gelen gerçek veriler
                updateBalanceDisplay();
                document.getElementById('totalFrozen').textContent = '0.00 USDT';
            }, 1000);
            
            // Otomatik güncelleme başlat
            setTimeout(() => {
                startTradingDataUpdates('BTC');
            }, 2000);
            
            // Wait for TradingView widget to load
            setTimeout(() => {
                if (window.tvWidget) {
                    console.log('TradingView widget hazır');
                } else {
                    console.log('TradingView widget bekleniyor...');
                    setTimeout(() => {
                        console.log('TradingView widget durumu:', window.tvWidget);
                    }, 1000);
                }
            }, 2000);
        });
    </script>
</body>
</html>
