<?php
require_once __DIR__ . '/../config/database.php';

try {
    $db = getDB();
    $db->exec("ALTER TABLE users ADD COLUMN IF NOT EXISTS is_admin TINYINT(1) NOT NULL DEFAULT 0");

    // En eski kullanıcıyı admin yap
    $stmt = $db->query("SELECT id, email FROM users ORDER BY id ASC LIMIT 1");
    $user = $stmt->fetch();
    if ($user) {
        $up = $db->prepare("UPDATE users SET is_admin = 1 WHERE id = ?");
        $up->execute([$user['id']]);
        echo 'Admin atandı: ' . $user['email'] . "\n";
    } else {
        echo "Kullanıcı bulunamadı. Önce bir kullanıcı oluşturun.\n";
    }
} catch (Exception $e) {
    echo 'Hata: ' . $e->getMessage() . "\n";
}




