<?php
require_once 'config/database.php';

try {
    $db = getDB();
    
    // Portfolio history tablosunu oluştur
    $sql = "CREATE TABLE IF NOT EXISTS portfolio_history (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        date DATE NOT NULL,
        total_value DECIMAL(15,2) NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        UNIQUE KEY unique_user_date (user_id, date),
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
    )";
    
    $db->exec($sql);
    echo "Portfolio history tablosu oluşturuldu.\n";
    
    // Mevcut kullanıcılar için bugünkü değerleri kaydet
    $stmt = $db->prepare("SELECT id FROM users");
    $stmt->execute();
    $users = $stmt->fetchAll();
    
    foreach ($users as $user) {
        $user_id = $user['id'];
        
        // Kullanıcının cüzdanlarını al
        $stmt = $db->prepare("SELECT * FROM wallets WHERE user_id = ?");
        $stmt->execute([$user_id]);
        $wallets = $stmt->fetchAll();
        
        // Kripto fiyatlarını al
        $crypto_prices = [];
        if (file_exists('assets/crypto_prices.json')) {
            $price_data = json_decode(file_get_contents('assets/crypto_prices.json'), true);
            $crypto_prices = $price_data['prices'] ?? [];
        }
        
        // Toplam değeri hesapla
        $total_value = 0;
        foreach ($wallets as $wallet) {
            $price = $crypto_prices[$wallet['coin_symbol']]['raw_price'] ?? 1;
            $total_value += floatval($wallet['balance']) * floatval($price);
        }
        
        // Bugünkü değeri kaydet
        $stmt = $db->prepare("INSERT INTO portfolio_history (user_id, date, total_value) VALUES (?, CURDATE(), ?) ON DUPLICATE KEY UPDATE total_value = ?");
        $stmt->execute([$user_id, $total_value, $total_value]);
        
        echo "Kullanıcı {$user_id} için portföy değeri kaydedildi: $" . number_format($total_value, 2) . "\n";
    }
    
    echo "Portfolio history tablosu başarıyla oluşturuldu ve veriler eklendi.\n";
    
} catch (Exception $e) {
    echo "Hata: " . $e->getMessage() . "\n";
}
?>
