<?php
require_once __DIR__ . '/../config/database.php';

try {
    $db = getDB();
    
    // is_admin kolonu yoksa oluştur
    $db->exec("ALTER TABLE users ADD COLUMN IF NOT EXISTS is_admin TINYINT(1) NOT NULL DEFAULT 0");
    
    // Admin kullanıcısı oluştur
    $email = 'admin@kriptocum.com';
    $password = 'admin123'; // Basit şifre
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
    $first_name = 'Admin';
    $last_name = 'User';
    
    // Önce admin kullanıcısının var olup olmadığını kontrol et
    $stmt = $db->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $existing_user = $stmt->fetch();
    
    if ($existing_user) {
        // Mevcut kullanıcıyı admin yap
        $stmt = $db->prepare("UPDATE users SET is_admin = 1 WHERE email = ?");
        $stmt->execute([$email]);
        echo "Mevcut kullanıcı admin yapıldı: $email\n";
    } else {
        // Yeni admin kullanıcısı oluştur
        $stmt = $db->prepare("INSERT INTO users (first_name, last_name, email, password, is_admin, created_at) VALUES (?, ?, ?, ?, 1, NOW())");
        $stmt->execute([$first_name, $last_name, $email, $hashed_password]);
        echo "Yeni admin kullanıcısı oluşturuldu: $email\n";
    }
    
    // Admin kullanıcısı için cüzdan oluştur
    $stmt = $db->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $admin_user = $stmt->fetch();
    
    if ($admin_user) {
        $user_id = $admin_user['id'];
        
        // USDT cüzdanı oluştur
        $stmt = $db->prepare("INSERT IGNORE INTO wallets (user_id, coin_symbol, balance, available, frozen) VALUES (?, 'USDT', 100000, 100000, 0)");
        $stmt->execute([$user_id]);
        
        // BTC cüzdanı oluştur
        $stmt = $db->prepare("INSERT IGNORE INTO wallets (user_id, coin_symbol, balance, available, frozen) VALUES (?, 'BTC', 10, 10, 0)");
        $stmt->execute([$user_id]);
        
        echo "Admin cüzdanları oluşturuldu.\n";
    }
    
    echo "\n=== ADMIN GİRİŞ BİLGİLERİ ===\n";
    echo "E-posta: $email\n";
    echo "Şifre: $password\n";
    echo "URL: http://localhost/kriptocum/admin/login.php\n";
    echo "=============================\n";
    
} catch (Exception $e) {
    echo "Hata: " . $e->getMessage() . "\n";
}
?>
