<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Giriş yapmanız gerekiyor.']);
    exit;
}

require_once 'config/database.php';

$user_id = $_SESSION['user_id'];
$input = json_decode(file_get_contents('php://input'), true);

$order_type = $input['order_type'] ?? 'buy';
$symbol = $input['symbol'] ?? 'BTC';
$price = floatval($input['price'] ?? 0);
$amount = floatval($input['amount'] ?? 0);

if ($price <= 0 || $amount <= 0) {
    echo json_encode(['success' => false, 'message' => 'Geçersiz fiyat veya miktar!']);
    exit;
}

try {
    $db = getDB();
    $db->beginTransaction();
    
    if ($order_type === 'buy') {
        // ALIŞ: USDT'den alıyoruz
        $total_cost = $price * $amount;
        
        // Kullanıcının USDT bakiyesini kontrol et
        $stmt = $db->prepare("SELECT balance, available FROM wallets WHERE user_id = ? AND coin_symbol = ?");
        $stmt->execute([$user_id, 'USDT']);
        $usdt_wallet = $stmt->fetch();
        
        if (!$usdt_wallet || bccomp($usdt_wallet['available'], $total_cost, 2) < 0) {
            $db->rollBack();
            $current_balance = $usdt_wallet ? number_format($usdt_wallet['available'], 2) : '0.00';
            $required = number_format($total_cost, 2);
            echo json_encode(['success' => false, 'message' => "Yetersiz USDT bakiyesi! Mevcut: {$current_balance} USDT, Gerekli: {$required} USDT"]);
            exit;
        }
        
        // USDT'yi azalt
        $stmt = $db->prepare("UPDATE wallets SET balance = balance - ?, available = available - ? WHERE user_id = ? AND coin_symbol = ?");
        $stmt->execute([$total_cost, $total_cost, $user_id, 'USDT']);
        
        // Coin bakiyesini artır
        $stmt = $db->prepare("SELECT balance FROM wallets WHERE user_id = ? AND coin_symbol = ?");
        $stmt->execute([$user_id, $symbol]);
        $coin_wallet = $stmt->fetch();
        
        if ($coin_wallet) {
            // Coin zaten varsa artır
            $stmt = $db->prepare("UPDATE wallets SET balance = balance + ?, available = available + ? WHERE user_id = ? AND coin_symbol = ?");
            $stmt->execute([$amount, $amount, $user_id, $symbol]);
        } else {
            // Coin yoksa yeni oluştur
            $stmt = $db->prepare("INSERT INTO wallets (user_id, coin_symbol, balance, available, frozen) VALUES (?, ?, ?, ?, 0)");
            $stmt->execute([$user_id, $symbol, $amount, $amount]);
        }
        
        // İşlem kaydı oluştur
        $stmt = $db->prepare("INSERT INTO transactions (user_id, type, coin_symbol, amount, price, total, status) VALUES (?, 'trade', ?, ?, ?, ?, 'completed')");
        $stmt->execute([$user_id, $symbol, $amount, $price, $total_cost]);
        
    } else {
        // SATIŞ: Coini USDT'ye çeviriyoruz
        $total_revenue = $price * $amount;
        
        // Kullanıcının coin bakiyesini kontrol et
        $stmt = $db->prepare("SELECT balance, available FROM wallets WHERE user_id = ? AND coin_symbol = ?");
        $stmt->execute([$user_id, $symbol]);
        $coin_wallet = $stmt->fetch();
        
        if (!$coin_wallet || bccomp($coin_wallet['available'], $amount, 8) < 0) {
            $db->rollBack();
            $current_balance = $coin_wallet ? number_format($coin_wallet['available'], 8) : '0.00000000';
            $required = number_format($amount, 8);
            echo json_encode(['success' => false, 'message' => "Yetersiz {$symbol} bakiyesi! Mevcut: {$current_balance} {$symbol}, Gerekli: {$required} {$symbol}"]);
            exit;
        }
        
        // Coini azalt
        $stmt = $db->prepare("UPDATE wallets SET balance = balance - ?, available = available - ? WHERE user_id = ? AND coin_symbol = ?");
        $stmt->execute([$amount, $amount, $user_id, $symbol]);
        
        // USDT bakiyesini artır
        $stmt = $db->prepare("SELECT balance FROM wallets WHERE user_id = ? AND coin_symbol = ?");
        $stmt->execute([$user_id, 'USDT']);
        $usdt_wallet = $stmt->fetch();
        
        if ($usdt_wallet) {
            // USDT varsa artır
            $stmt = $db->prepare("UPDATE wallets SET balance = balance + ?, available = available + ? WHERE user_id = ? AND coin_symbol = ?");
            $stmt->execute([$total_revenue, $total_revenue, $user_id, 'USDT']);
        } else {
            // USDT yoksa yeni oluştur
            $stmt = $db->prepare("INSERT INTO wallets (user_id, coin_symbol, balance, available, frozen) VALUES (?, 'USDT', ?, ?, 0)");
            $stmt->execute([$user_id, $total_revenue, $total_revenue]);
        }
        
        // İşlem kaydı oluştur (satış için amount negatif)
        $stmt = $db->prepare("INSERT INTO transactions (user_id, type, coin_symbol, amount, price, total, status) VALUES (?, 'trade', ?, ?, ?, ?, 'completed')");
        $stmt->execute([$user_id, $symbol, -$amount, $price, $total_revenue]);
    }
    
    $db->commit();
    
    echo json_encode([
        'success' => true,
        'message' => ($order_type === 'buy' ? 'Alış' : 'Satış') . ' işlemi başarıyla gerçekleştirildi!'
    ]);
    
} catch (Exception $e) {
    $db->rollBack();
    echo json_encode(['success' => false, 'message' => 'Veritabanı hatası: ' . $e->getMessage()]);
}
?>

