<?php
session_start();
require_once 'config/database.php';

// Sayfa içeriğini veritabanından çek
try {
    $db = getDB();
    $stmt = $db->prepare("SELECT * FROM legal_pages WHERE slug = 'privacy' AND is_active = 1");
    $stmt->execute();
    $page = $stmt->fetch();
    
    if (!$page) {
        header('Location: index.php');
        exit;
    }
} catch (Exception $e) {
    $page = null;
}

?><!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gizlilik Politikası - Kriptocum</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="assets/style.css">
    <script src="assets/js/dropdown.js"></script>
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    <style>.hidden{display:none}</style>
</head>
<body class="bg-background text-foreground">
<?php include 'components/header.php'; ?>

<main>
<div class="pt-24 min-h-screen bg-gray-50">
    <div class="container mx-auto px-4 py-12">
        <div class="max-w-4xl mx-auto">
            <div class="bg-white rounded-lg shadow-sm p-8">
                <h1 class="text-4xl font-bold text-gray-900 mb-6"><?php echo htmlspecialchars($page['title'] ?? 'Gizlilik Politikası'); ?></h1>
                <div class="prose max-w-none">
                    <?php echo $page['content'] ?? '<p>İçerik yükleniyor...</p>'; ?>
                </div>
            </div>
        </div>
    </div>
</div>
</main>

<?php include 'components/footer.php'; ?>

<style>
.prose h1 {
    font-size: 2.25rem;
    font-weight: 700;
    margin-top: 2rem;
    margin-bottom: 1rem;
    color: #111827;
}
.prose h2 {
    font-size: 1.5rem;
    font-weight: 600;
    margin-top: 1.5rem;
    margin-bottom: 0.75rem;
    color: #1f2937;
}
.prose p {
    margin-bottom: 1rem;
    color: #4b5563;
    line-height: 1.75;
}
.prose ul {
    list-style-type: disc;
    padding-left: 1.5rem;
    margin-bottom: 1rem;
}
.prose li {
    margin-bottom: 0.5rem;
    color: #4b5563;
}
</style>

</body>
</html>
