<?php
// Hata mesajlarını kontrol et
$error_message = '';
if (isset($_GET['error'])) {
    switch ($_GET['error']) {
        case 'invalid_credentials':
            $error_message = 'E-posta veya şifre hatalı. Lütfen tekrar deneyin.';
            break;
        case 'email_required':
            $error_message = 'E-posta adresi gereklidir.';
            break;
        case 'password_required':
            $error_message = 'Şifre gereklidir.';
            break;
        case 'account_inactive':
            $error_message = 'Hesabınız aktif değil. Lütfen destek ekibi ile iletişime geçin.';
            break;
        case 'database_error':
            $error_message = 'Bir hata oluştu. Lütfen tekrar deneyin.';
            break;
        case 'invalid_request':
            $error_message = 'Geçersiz istek.';
            break;
        default:
            $error_message = 'Bir hata oluştu.';
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Giriş Yap - Kriptocum</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="assets/style.css">
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
</head>
<body class="bg-background text-foreground">
    <!-- Modal Overlay -->
    <div class="fixed inset-0 bg-black/50 backdrop-blur-sm z-40"></div>
    
    <!-- Login Modal -->
    <div role="dialog" id="login-modal" aria-describedby="login-description" aria-labelledby="login-title" 
         data-state="open" data-slot="dialog-content" 
         class="bg-background data-[state=open]:animate-in data-[state=closed]:animate-out data-[state=closed]:fade-out-0 data-[state=open]:fade-in-0 data-[state=closed]:zoom-out-95 data-[state=open]:zoom-in-95 fixed top-[50%] left-[50%] z-50 grid max-w-[calc(100%-2rem)] translate-x-[-50%] translate-y-[-50%] gap-4 border duration-200 sm:max-w-xl p-0 border-none shadow-2xl rounded-xl w-[95vw] sm:w-full max-h-[90vh] overflow-hidden bg-gradient-to-b from-background to-background/95 backdrop-blur-sm" 
         tabindex="-1" style="pointer-events: auto;">
        
        <h2 id="login-title" data-slot="dialog-title" class="text-lg leading-none font-semibold">
            <span class="sr-only">Kimlik Doğrulama</span>
        </h2>
        
        <p id="login-description" data-slot="dialog-description" class="text-muted-foreground text-sm">
            <span class="sr-only">Güvenli bir şekilde giriş yapın veya hesap oluşturun.</span>
        </p>
        
        <!-- Background Effects -->
        <div class="absolute inset-0 overflow-hidden pointer-events-none">
            <div class="absolute -top-24 -left-24 w-64 h-64 bg-primary/10 rounded-full blur-3xl"></div>
            <div class="absolute -bottom-24 -right-24 w-64 h-64 bg-primary/10 rounded-full blur-3xl"></div>
        </div>
        
        <!-- Close Button -->
        <button type="button" onclick="window.history.back()" 
                class="hidden absolute right-4 top-4 rounded-sm opacity-70 ring-offset-background transition-opacity hover:opacity-100 focus:outline-none focus:ring-2 focus:ring-ring focus:ring-offset-2 disabled:pointer-events-none data-[state=open]:bg-accent data-[state=open]:text-muted-foreground">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x h-4 w-4">
                <path d="M18 6 6 18"></path>
                <path d="m6 6 12 12"></path>
            </svg>
            <span class="sr-only">Kapat</span>
        </button>
        
        <!-- Modal Content -->
        <div class="max-h-[90vh] pb-8 overflow-y-auto scrollbar-hide auth-modal-content opacity-100">
            <div class="p-8">
                <div class="space-y-6">
                    <!-- Header -->
                    <div class="space-y-2 text-center">
                        <h2 class="text-3xl font-bold">Tekrar hoş geldiniz</h2>
                        <p class="text-muted-foreground">Hesabınızda oturum açmak için kimlik bilgilerinizi girin</p>
                    </div>
                    
                    <!-- Login Form -->
                    <?php if (!empty($error_message)): ?>
                    <div class="bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-md text-sm flex items-center space-x-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-alert-circle flex-shrink-0">
                            <circle cx="12" cy="12" r="10"></circle>
                            <line x1="12" x2="12" y1="8" y2="12"></line>
                            <line x1="12" x2="12.01" y1="16" y2="16"></line>
                        </svg>
                        <span><?php echo htmlspecialchars($error_message); ?></span>
                    </div>
                    <?php endif; ?>
                    <form class="space-y-4" action="auth/login.php" method="POST">
                        <!-- Email Field -->
                        <div class="space-y-2">
                            <div class="relative transition-all duration-200">
                                <div class="flex-1 w-full flex flex-col">
                                    <div class="border-input placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground h-9 w-full min-w-0 rounded-md border bg-transparent px-3 text-base outline-hidden disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm aria-invalid:ring-destructive/20 aria-invalid:border-destructive flex items-center focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] shadow-sm pl-10 py-6 transition-all">
                                        <input data-slot="input" class="flex-1 bg-transparent border-none p-0 m-0 focus:outline-none focus:ring-0" 
                                               placeholder="E-posta" required="" type="email" name="email" value="">
                                    </div>
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-mail absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 transition-colors text-muted-foreground">
                                    <rect width="20" height="16" x="2" y="4" rx="2"></rect>
                                    <path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"></path>
                                </svg>
                            </div>
                        </div>
                        
                        <!-- Password Field -->
                        <div class="space-y-2">
                            <div class="relative transition-all duration-200">
                                <div class="flex-1 w-full flex flex-col">
                                    <div class="border-input placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground h-9 w-full min-w-0 rounded-md border bg-transparent px-3 text-base outline-hidden disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm aria-invalid:ring-destructive/20 aria-invalid:border-destructive flex items-center focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] shadow-sm pl-10 pr-10 py-6 transition-all">
                                        <input data-slot="input" class="flex-1 bg-transparent border-none p-0 m-0 focus:outline-none focus:ring-0" 
                                               placeholder="Şifre" required="" type="password" name="password" value="" id="password">
                                    </div>
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-lock absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 transition-colors text-muted-foreground">
                                    <rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect>
                                    <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                                </svg>
                                <button type="button" onclick="togglePassword()" class="absolute right-3 top-1/2 -translate-y-1/2 h-5 w-5 text-muted-foreground hover:text-primary transition-colors" tabindex="-1">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-eye" id="eye-icon">
                                        <path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path>
                                        <circle cx="12" cy="12" r="3"></circle>
                                    </svg>
                                </button>
                            </div>
                        </div>
                        
                        <!-- Remember Me & Forgot Password -->
                        <div class="flex items-center justify-between">
                            <div class="flex items-center space-x-2">
                                <button type="button" role="checkbox" aria-checked="false" data-state="unchecked" value="on" data-slot="checkbox" class="size-4 rounded-md peer border-input data-[state=checked]:bg-primary data-[state=checked]:text-primary-foreground data-[state=checked]:border-primary focus-visible:border-ring focus-visible:ring-ring/50 aria-invalid:ring-destructive/20 aria-invalid:border-destructive shrink-0 border shadow-2xs transition-shadow outline-hidden focus-visible:ring-[3px] disabled:cursor-not-allowed disabled:opacity-50" id="remember-me"></button>
                                <input aria-hidden="true" tabindex="-1" type="checkbox" value="on" style="position: absolute; pointer-events: none; opacity: 0; margin: 0px; transform: translateX(-100%); width: 16px; height: 16px;">
                                <label for="remember-me" class="text-sm text-muted-foreground cursor-pointer">Beni hatırla</label>
                            </div>
                            <button data-slot="button" class="inline-flex cursor-pointer items-center justify-center gap-2 whitespace-nowrap rounded-md font-medium transition-[color,box-shadow] disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-hidden focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 aria-invalid:border-destructive text-primary underline-offset-4 hover:underline p-0 h-auto text-sm" type="button">Şifrenizi mi unuttunuz?</button>
                        </div>
                        
                        <!-- Submit Button -->
                        <button data-slot="button" class="inline-flex cursor-pointer items-center justify-center gap-2 whitespace-nowrap rounded-md font-medium transition-[color,box-shadow] disabled:pointer-events-none [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-hidden focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 aria-invalid:border-destructive bg-primary text-primary-foreground shadow-2xs hover:bg-primary/90 h-10 px-4 w-full py-6 text-base disabled:opacity-50 disabled:cursor-not-allowed" type="submit">Oturum aç</button>
                    </form>
                    
                    <!-- Wallet Login -->
                    <div class="space-y-4">
                        <button data-slot="button" class="inline-flex cursor-pointer items-center justify-center gap-2 whitespace-nowrap rounded-md font-medium transition-[color,box-shadow] disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-hidden focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 aria-invalid:border-destructive border border-input bg-background shadow-2xs hover:bg-accent hover:text-accent-foreground h-10 px-4 w-full py-6 text-base">
                            <svg class="mr-2 h-5 w-5" aria-hidden="true" focusable="false" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                <path fill="currentColor" d="M461.2 128H80c-8.84 0-16-7.16-16-16s7.16-16 16-16h384c8.84 0 16-7.16 16-16 0-26.51-21.49-48-48-48H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h397.2c28.02 0 50.8-21.53 50.8-48V176c0-26.47-22.78-48-50.8-48zM416 336c-17.67 0-32-14.33-32-32s14.33-32 32-32 32 14.33 32 32-14.33 32-32 32z"></path>
                            </svg>
                            Cüzdan ile devam et
                        </button>
                    </div>
                    
                    <!-- Trust Indicators -->
                    <div class="text-center text-xs text-muted-foreground">
                        <p>Dünya çapında 10.000+ kullanıcı tarafından güvenilen</p>
                        <div class="flex justify-center mt-2 space-x-1">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                        </div>
                    </div>
                    
                    <!-- Sign Up Link -->
                    <div class="text-center">
                        <p class="text-sm text-muted-foreground">Hesabınız yok mu? 
                            <a href="register.php" class="inline-flex cursor-pointer items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-[color,box-shadow] disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-hidden focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 aria-invalid:border-destructive text-primary underline-offset-4 hover:underline p-0 h-auto">Kaydol</a>
                        </p>
                    </div>
                </div>
            </div>
            
            <!-- Security Features -->
            <div class="px-8 pb-8 pt-2">
                <div class="flex flex-col items-center justify-center space-y-3 text-center">
                    <div class="flex items-center justify-center space-x-2 text-xs text-muted-foreground">
                        <div class="flex items-center justify-center w-8 h-8 rounded-full bg-primary/10">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-lock h-4 w-4 text-primary">
                                <rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect>
                                <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                            </svg>
                        </div>
                        <span>Güvenli kimlik doğrulama</span>
                        <div class="w-px h-4 bg-border"></div>
                        <div class="flex items-center justify-center w-8 h-8 rounded-full bg-primary/10">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-shield h-4 w-4 text-primary">
                                <path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"></path>
                            </svg>
                        </div>
                        <span>Veri koruma</span>
                        <div class="w-px h-4 bg-border"></div>
                        <div class="flex items-center justify-center w-8 h-8 rounded-full bg-primary/10">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-4 w-4 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                        </div>
                        <span>Doğrulanmış güvenlik</span>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Close Button -->
        <button type="button" onclick="window.history.back()" 
                class="ring-offset-background focus:ring-ring data-[state=open]:bg-accent data-[state=open]:text-muted-foreground absolute top-4 right-4 rounded-xs opacity-70 transition-opacity hover:opacity-100 focus:ring-2 focus:ring-offset-2 focus:outline-hidden disabled:pointer-events-none [&_svg]:pointer-events-none [&_svg]:shrink-0 [&_svg:not([class*='size-'])]:size-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                <path d="M18 6 6 18"></path>
                <path d="m6 6 12 12"></path>
            </svg>
            <span class="sr-only">Kapat</span>
        </button>
    </div>

    <script>
        // Password toggle functionality
        function togglePassword() {
            const passwordInput = document.getElementById('password');
            const eyeIcon = document.getElementById('eye-icon');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                eyeIcon.innerHTML = '<path d="M9.88 9.88a3 3 0 1 0 4.24 4.24"></path><path d="M10.73 5.08A10.43 10.43 0 0 1 12 5c7 0 10 7 10 7a13.16 13.16 0 0 1-1.67 2.68"></path><path d="M6.61 6.61A13.526 13.526 0 0 0 2 12s3 7 10 7a9.74 9.74 0 0 0 5.39-1.61"></path><line x1="2" x2="22" y1="2" y2="22"></line>';
            } else {
                passwordInput.type = 'password';
                eyeIcon.innerHTML = '<path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path><circle cx="12" cy="12" r="3"></circle>';
            }
        }

        // Remember me checkbox functionality
        document.addEventListener('DOMContentLoaded', function() {
            const rememberCheckbox = document.getElementById('remember-me');
            const hiddenCheckbox = rememberCheckbox.nextElementSibling;
            
            rememberCheckbox.addEventListener('click', function() {
                const isChecked = rememberCheckbox.getAttribute('data-state') === 'checked';
                if (isChecked) {
                    rememberCheckbox.setAttribute('data-state', 'unchecked');
                    rememberCheckbox.setAttribute('aria-checked', 'false');
                    hiddenCheckbox.checked = false;
                } else {
                    rememberCheckbox.setAttribute('data-state', 'checked');
                    rememberCheckbox.setAttribute('aria-checked', 'true');
                    hiddenCheckbox.checked = true;
                }
            });
            
            // Eğer URL'de error parametresi varsa, modal'ın açık kalmasını sağla
            const urlParams = new URLSearchParams(window.location.search);
            if (urlParams.has('error')) {
                // URL'yi temizle ama error parametresini koruyarak sayfayı yeniden yükleme
                // Modal zaten açık olacak
            }
        });

        // Close modal on escape key (sadece hata yoksa)
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                const urlParams = new URLSearchParams(window.location.search);
                if (!urlParams.has('error')) {
                    window.history.back();
                }
            }
        });

        // Close modal on overlay click (sadece hata yoksa)
        document.addEventListener('click', function(e) {
            if (e.target.classList.contains('bg-black/50')) {
                const urlParams = new URLSearchParams(window.location.search);
                if (!urlParams.has('error')) {
                    window.history.back();
                }
            }
        });
    </script>
</body>
</html>


