<?php
session_start();
$is_logged_in = isset($_SESSION['user_id']);
$user_name = '';
if ($is_logged_in) {
    require_once 'config/database.php';
    try {
        $db = getDB();
        $stmt = $db->prepare("SELECT first_name, last_name FROM users WHERE id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $user = $stmt->fetch();
        if ($user) {
            $user_name = $user['first_name'] . ' ' . $user['last_name'];
        }
    } catch (Exception $e) {
        // Hata durumunda sessizce devam et
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kriptocum - Kripto Para Platformu</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="assets/style.css">
    <script src="assets/js/dropdown.js"></script>
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
</head>
<body class="bg-background text-foreground">
    <?php include 'components/header.php'; ?>
    
            <main class="pt-16">
                <div class="w-full bg-background text-foreground overflow-hidden">
                    <!-- Hero Section -->
                    <section class="relative min-h-screen flex items-center justify-center overflow-hidden">
                        <div class="absolute inset-0 z-0">
                            <div class="absolute inset-0 bg-gradient-to-br from-blue-500/20 via-purple-500/20 to-indigo-500/20"></div>
                            <div class="absolute top-0 left-0 w-full h-full">
                                <div class="absolute top-1/4 left-1/4 w-96 h-96 bg-gradient-to-br from-blue-400/30 to-cyan-400/30 rounded-full blur-3xl animate-pulse"></div>
                                <div class="absolute bottom-1/4 right-1/4 w-96 h-96 bg-gradient-to-br from-purple-400/30 to-pink-400/30 rounded-full blur-3xl animate-pulse delay-1000"></div>
                                <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-96 h-96 bg-gradient-to-br from-indigo-400/20 to-blue-400/20 rounded-full blur-3xl animate-pulse delay-2000"></div>
                            </div>
                        </div>
                        <div class="container mx-auto px-4 md:px-6 relative z-10 pt-20">
                            <div class="flex flex-col lg:flex-row items-center gap-8 lg:gap-12 justify-between">
                                <div class="text-center lg:w-3/5 lg:text-left">
                                    <div class="inline-flex items-center gap-2 bg-gradient-to-r from-blue-100 to-purple-100 border border-blue-200 rounded-full px-4 py-2 text-sm font-medium text-blue-700 mb-6 md:mb-8">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-sparkles w-4 h-4">
                                            <path d="M9.937 15.5A2 2 0 0 0 8.5 14.063l-6.135-1.582a.5.5 0 0 1 0-.962L8.5 9.936A2 2 0 0 0 9.937 8.5l1.582-6.135a.5.5 0 0 1 .963 0L14.063 8.5A2 2 0 0 0 15.5 9.937l6.135 1.581a.5.5 0 0 1 0 .964L15.5 14.063a2 2 0 0 0-1.437 1.437l-1.582 6.135a.5.5 0 0 1-.963 0z"></path>
                                            <path d="M20 3v4"></path>
                                            <path d="M22 5h-4"></path>
                                            <path d="M4 17v2"></path>
                                            <path d="M5 18H3"></path>
                                        </svg>
                                        <?php if ($is_logged_in): ?>
                                            Hoş geldiniz, <?php echo htmlspecialchars($user_name); ?>!
                                        <?php else: ?>
                                            #1 Kripto İşlem Platformu
                                        <?php endif; ?>
                                    </div>
                                    <h1 class="text-4xl sm:text-5xl md:text-6xl lg:text-7xl font-bold mb-4 md:mb-6 leading-tight">
                                        <?php if ($is_logged_in): ?>
                                            <div class="-mb-1 md:-mb-2">İşlem Paneline</div>
                                            <span class="bg-gradient-to-r from-blue-600 via-purple-600 to-indigo-600 bg-clip-text text-transparent">Hoş Geldiniz</span>
                                        <?php else: ?>
                                            <div class="-mb-1 md:-mb-2">Kripto İşlem</div>
                                            <span class="bg-gradient-to-r from-blue-600 via-purple-600 to-indigo-600 bg-clip-text text-transparent">profesyonel gibi</span>
                                        <?php endif; ?>
                                    </h1>
                                    <p class="text-lg md:text-xl lg:text-2xl mb-6 md:mb-8 max-w-2xl leading-relaxed mx-auto lg:mx-0 text-gray-600">
                                        <?php if ($is_logged_in): ?>
                                            Portföyünüzü yönetin, gerçek zamanlı işlemler yapın ve kripto para dünyasında başarıya ulaşın.
                                        <?php else: ?>
                                            Gelişmiş işlem araçları, şimşek hızında işlem ve eşsiz güvenlik. Dünya çapında milyonlarca trader'a katılın.
                                        <?php endif; ?>
                                    </p>
                                    <div class="flex flex-col sm:flex-row gap-4 mb-8 md:mb-12 justify-center lg:justify-start">
                                        <?php if ($is_logged_in): ?>
                                            <a class="group relative inline-flex items-center justify-center gap-2 px-6 md:px-8 py-3 md:py-4 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 rounded-xl md:rounded-2xl font-semibold transition-all duration-300 text-white shadow-xl hover:shadow-2xl transform hover:scale-105 w-fit mx-auto sm:mx-0" href="trade.php">
                                                <span class="relative z-10 flex items-center justify-center gap-2">
                                                    İşlem Yapmaya Başla
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-right w-5 h-5 group-hover:translate-x-1 transition-transform">
                                                        <path d="M5 12h14"></path>
                                                        <path d="m12 5 7 7-7 7"></path>
                                                    </svg>
                                                </span>
                                                <div class="absolute inset-0 bg-gradient-to-r from-blue-700 to-purple-700 rounded-xl md:rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                                            </a>
                                            <a class="group relative inline-flex items-center justify-center gap-2 px-6 md:px-8 py-3 md:py-4 bg-white hover:bg-gray-50 border-2 border-blue-600 text-blue-600 hover:text-blue-700 rounded-xl md:rounded-2xl font-semibold transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105 w-fit mx-auto sm:mx-0" href="portfolio.php">
                                                <span class="relative z-10 flex items-center justify-center gap-2">
                                                    Portföyümü Görüntüle
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chart-line w-5 h-5 group-hover:scale-110 transition-transform">
                                                        <path d="M3 3v18h18"></path>
                                                        <path d="m19 9-5 5-4-4-3 3"></path>
                                                    </svg>
                                                </span>
                                            </a>
                                        <?php else: ?>
                                            <a class="group relative inline-flex items-center justify-center gap-2 px-6 md:px-8 py-3 md:py-4 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 rounded-xl md:rounded-2xl font-semibold transition-all duration-300 text-white shadow-xl hover:shadow-2xl transform hover:scale-105 w-fit mx-auto sm:mx-0" href="register.php">
                                            <span class="relative z-10 flex items-center justify-center gap-2">
                                                    Ücretsiz İşlem Başlat
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-right w-5 h-5 group-hover:translate-x-1 transition-transform">
                                                    <path d="M5 12h14"></path>
                                                    <path d="m12 5 7 7-7 7"></path>
                                                </svg>
                                            </span>
                                            <div class="absolute inset-0 bg-gradient-to-r from-blue-700 to-purple-700 rounded-xl md:rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                                        </a>
                                        <?php endif; ?>
                                    </div>
                                    <div class="flex flex-wrap gap-4 md:gap-6 justify-center lg:justify-start">
                                        <div class="flex items-center gap-2 text-sm">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check-big w-4 h-4 text-green-500">
                                                <path d="M21.801 10A10 10 0 1 1 17 3.335"></path>
                                                <path d="m9 11 3 3L22 4"></path>
                                            </svg>
                                            <span class="text-gray-600">Güvenli İşlem</span>
                                        </div>
                                        <div class="flex items-center gap-2 text-sm">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check-big w-4 h-4 text-green-500">
                                                <path d="M21.801 10A10 10 0 1 1 17 3.335"></path>
                                                <path d="m9 11 3 3L22 4"></path>
                                            </svg>
                                            <span class="text-gray-600">Gerçek Zamanlı Veri</span>
                                        </div>
                                        <div class="flex items-center gap-2 text-sm">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check-big w-4 h-4 text-green-500">
                                                <path d="M21.801 10A10 10 0 1 1 17 3.335"></path>
                                                <path d="m9 11 3 3L22 4"></path>
                                            </svg>
                                            <span class="text-gray-600">7/24 Destek</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="lg:w-2/5 w-full">
                                    <div class="relative backdrop-blur-xl rounded-2xl p-4 md:p-6 lg:p-8 shadow-2xl border bg-white/90 border-gray-200">
                                        <div class="absolute -top-4 -right-4 w-24 h-24 bg-gradient-to-br from-blue-500/20 to-purple-500/20 rounded-full blur-xl"></div>
                                        <div class="absolute -bottom-4 -left-4 w-32 h-32 bg-gradient-to-br from-purple-500/20 to-pink-500/20 rounded-full blur-xl"></div>
                                        <div class="relative z-10">
                                            <div class="space-y-3 md:space-y-4">
                                                <div class="grid grid-cols-3 gap-2 md:gap-4 text-xs md:text-sm font-medium text-gray-500 px-2">
                                                    <div>Varlık</div>
                                                    <div class="text-center flex gap-2"><span>Fiyat</span> /<span>Piyasa Değeri</span></div>
                                                    <div class="text-right">24s</div>
                                                </div>
                                                <div class="space-y-3 md:space-y-4">
                                                    <a href="trade.php?symbol=BTC-USDT">
                                                        <div class="grid grid-cols-3 gap-2 md:gap-4 p-3 md:p-4 rounded-xl transition-all duration-300 hover:scale-[1.02] cursor-pointer group bg-gray-50 hover:bg-gray-100 border border-gray-200 hover:border-gray-300">
                                                            <div class="col-span-1 flex items-center gap-2 md:gap-3">
                                                                <div class="min-w-[2rem] min-h-[2rem] w-8 h-8 md:min-w-[3rem] md:min-h-[3rem] md:w-12 md:h-12 rounded-full flex items-center justify-center overflow-hidden border-2 flex-shrink-0 bg-gray-100 border-gray-200">
                                                                    <?php $btcImg = findCoinImage('BTC'); if ($btcImg) { ?>
                                                                        <img alt="BTC" class="w-6 h-6 md:w-8 md:h-8 object-cover" src="<?php echo htmlspecialchars($btcImg); ?>">
                                                                    <?php } else { ?>
                                                                        <div class="w-6 h-6 md:w-8 md:h-8 rounded-full bg-gray-200 text-gray-700 text-[10px] md:text-[12px] font-bold flex items-center justify-center">BT</div>
                                                                    <?php } ?>
                                                                </div>
                                                                <div>
                                                                    <div class="font-semibold text-xs md:text-sm group-hover:text-blue-600 transition-colors">BTC</div>
                                                                    <div class="text-[10px] md:text-xs text-gray-500">BTCUSDT</div>
                                                                </div>
                                                            </div>
                                                            <div class="col-span-1 flex flex-col items-center justify-center gap-1">
                                                                <div class="font-mono font-semibold text-xs md:text-sm">$111,490.01</div>
                                                                <div class="font-medium text-[10px] md:text-xs text-gray-500">$111.49B</div>
                                                            </div>
                                                            <div class="col-span-1 flex items-center justify-end">
                                                                <div class="flex items-center gap-1 px-2 py-1 rounded-lg text-xs md:text-sm font-semibold text-green-600 bg-green-100 text-green-600">
                                                                    +1.31%
                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-up-right h-3 w-3">
                                                                        <path d="M7 7h10v10"></path>
                                                                        <path d="M7 17 17 7"></path>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <a href="trade.php?symbol=ETH-USDT">
                                                        <div class="grid grid-cols-3 gap-2 md:gap-4 p-3 md:p-4 rounded-xl transition-all duration-300 hover:scale-[1.02] cursor-pointer group bg-gray-50 hover:bg-gray-100 border border-gray-200 hover:border-gray-300">
                                                            <div class="col-span-1 flex items-center gap-2 md:gap-3">
                                                                <div class="min-w-[2rem] min-h-[2rem] w-8 h-8 md:min-w-[3rem] md:min-h-[3rem] md:w-12 md:h-12 rounded-full flex items-center justify-center overflow-hidden border-2 flex-shrink-0 bg-gray-100 border-gray-200">
                                                                    <?php $ethImg = findCoinImage('ETH'); if ($ethImg) { ?>
                                                                        <img alt="ETH" class="w-6 h-6 md:w-8 md:h-8 object-cover" src="<?php echo htmlspecialchars($ethImg); ?>">
                                                                    <?php } else { ?>
                                                                        <div class="w-6 h-6 md:w-8 md:h-8 rounded-full bg-gray-200 text-gray-700 text-[10px] md:text-[12px] font-bold flex items-center justify-center">ET</div>
                                                                    <?php } ?>
                                                                </div>
                                                                <div>
                                                                    <div class="font-semibold text-xs md:text-sm group-hover:text-blue-600 transition-colors">ETH</div>
                                                                    <div class="text-[10px] md:text-xs text-gray-500">ETHUSDT</div>
                                                                </div>
                                                            </div>
                                                            <div class="col-span-1 flex flex-col items-center justify-center gap-1">
                                                                <div class="font-mono font-semibold text-xs md:text-sm">$3,931.85</div>
                                                                <div class="font-medium text-[10px] md:text-xs text-gray-500">$3.93B</div>
                                                            </div>
                                                            <div class="col-span-1 flex items-center justify-end">
                                                                <div class="flex items-center gap-1 px-2 py-1 rounded-lg text-xs md:text-sm font-semibold text-green-600 bg-green-100 text-green-600">
                                                                    +0.98%
                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-up-right h-3 w-3">
                                                                        <path d="M7 7h10v10"></path>
                                                                        <path d="M7 17 17 7"></path>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <a href="trade.php?symbol=USDC-USDT">
                                                        <div class="grid grid-cols-3 gap-2 md:gap-4 p-3 md:p-4 rounded-xl transition-all duration-300 hover:scale-[1.02] cursor-pointer group bg-gray-50 hover:bg-gray-100 border border-gray-200 hover:border-gray-300">
                                                            <div class="col-span-1 flex items-center gap-2 md:gap-3">
                                                                <div class="min-w-[2rem] min-h-[2rem] w-8 h-8 md:min-w-[3rem] md:min-h-[3rem] md:w-12 md:h-12 rounded-full flex items-center justify-center overflow-hidden border-2 flex-shrink-0 bg-gray-100 border-gray-200">
                                                                    <?php $usdcImg = findCoinImage('USDC'); if ($usdcImg) { ?>
                                                                        <img alt="USDC" class="w-6 h-6 md:w-8 md:h-8 object-cover" src="<?php echo htmlspecialchars($usdcImg); ?>">
                                                                    <?php } else { ?>
                                                                        <div class="w-6 h-6 md:w-8 md:h-8 rounded-full bg-gray-200 text-gray-700 text-[10px] md:text-[12px] font-bold flex items-center justify-center">US</div>
                                                                    <?php } ?>
                                                                </div>
                                                                <div>
                                                                    <div class="font-semibold text-xs md:text-sm group-hover:text-blue-600 transition-colors">USDC</div>
                                                                    <div class="text-[10px] md:text-xs text-gray-500">USDCUSDT</div>
                                                                </div>
                                                            </div>
                                                            <div class="col-span-1 flex flex-col items-center justify-center gap-1">
                                                                <div class="font-mono font-semibold text-xs md:text-sm">$0.9997</div>
                                                                <div class="font-medium text-[10px] md:text-xs text-gray-500">$999.70K</div>
                                                            </div>
                                                            <div class="col-span-1 flex items-center justify-end">
                                                                <div class="flex items-center gap-1 px-2 py-1 rounded-lg text-xs md:text-sm font-semibold text-red-600 bg-red-100 text-red-600">
                                                                    -0.01%
                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-down-right h-3 w-3">
                                                                        <path d="m7 7 10 10"></path>
                                                                        <path d="M17 7v10H7"></path>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <a href="trade.php?symbol=SOL-USDT">
                                                        <div class="grid grid-cols-3 gap-2 md:gap-4 p-3 md:p-4 rounded-xl transition-all duration-300 hover:scale-[1.02] cursor-pointer group bg-gray-50 hover:bg-gray-100 border border-gray-200 hover:border-gray-300">
                                                            <div class="col-span-1 flex items-center gap-2 md:gap-3">
                                                                <div class="min-w-[2rem] min-h-[2rem] w-8 h-8 md:min-w-[3rem] md:min-h-[3rem] md:w-12 md:h-12 rounded-full flex items-center justify-center overflow-hidden border-2 flex-shrink-0 bg-gray-100 border-gray-200">
                                                                    <?php $solImg = findCoinImage('SOL'); if ($solImg) { ?>
                                                                        <img alt="SOL" class="w-6 h-6 md:w-8 md:h-8 object-cover" src="<?php echo htmlspecialchars($solImg); ?>">
                                                                    <?php } else { ?>
                                                                        <div class="w-6 h-6 md:w-8 md:h-8 rounded-full bg-gray-200 text-gray-700 text-[10px] md:text-[12px] font-bold flex items-center justify-center">SO</div>
                                                                    <?php } ?>
                                                                </div>
                                                                <div>
                                                                    <div class="font-semibold text-xs md:text-sm group-hover:text-blue-600 transition-colors">SOL</div>
                                                                    <div class="text-[10px] md:text-xs text-gray-500">SOLUSDT</div>
                                                                </div>
                                                            </div>
                                                            <div class="col-span-1 flex flex-col items-center justify-center gap-1">
                                                                <div class="font-mono font-semibold text-xs md:text-sm">$192.26</div>
                                                                <div class="font-medium text-[10px] md:text-xs text-gray-500">$192.26M</div>
                                                            </div>
                                                            <div class="col-span-1 flex items-center justify-end">
                                                                <div class="flex items-center gap-1 px-2 py-1 rounded-lg text-xs md:text-sm font-semibold text-green-600 bg-green-100 text-green-600">
                                                                    +1.49%
                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-up-right h-3 w-3">
                                                                        <path d="M7 7h10v10"></path>
                                                                        <path d="M7 17 17 7"></path>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                    <a href="trade.php?symbol=XRP-USDT">
                                                        <div class="grid grid-cols-3 gap-2 md:gap-4 p-3 md:p-4 rounded-xl transition-all duration-300 hover:scale-[1.02] cursor-pointer group bg-gray-50 hover:bg-gray-100 border border-gray-200 hover:border-gray-300">
                                                            <div class="col-span-1 flex items-center gap-2 md:gap-3">
                                                                <div class="min-w-[2rem] min-h-[2rem] w-8 h-8 md:min-w-[3rem] md:min-h-[3rem] md:w-12 md:h-12 rounded-full flex items-center justify-center overflow-hidden border-2 flex-shrink-0 bg-gray-100 border-gray-200">
                                                                    <?php $xrpImg = findCoinImage('XRP'); if ($xrpImg) { ?>
                                                                        <img alt="XRP" class="w-6 h-6 md:w-8 md:h-8 object-cover" src="<?php echo htmlspecialchars($xrpImg); ?>">
                                                                    <?php } else { ?>
                                                                        <div class="w-6 h-6 md:w-8 md:h-8 rounded-full bg-gray-200 text-gray-700 text-[10px] md:text-[12px] font-bold flex items-center justify-center">XR</div>
                                                                    <?php } ?>
                                                                </div>
                                                                <div>
                                                                    <div class="font-semibold text-xs md:text-sm group-hover:text-blue-600 transition-colors">XRP</div>
                                                                    <div class="text-[10px] md:text-xs text-gray-500">XRPUSDT</div>
                                                                </div>
                                                            </div>
                                                            <div class="col-span-1 flex flex-col items-center justify-center gap-1">
                                                                <div class="font-mono font-semibold text-xs md:text-sm">$2.60</div>
                                                                <div class="font-medium text-[10px] md:text-xs text-gray-500">$2.60M</div>
                                                            </div>
                                                            <div class="col-span-1 flex items-center justify-end">
                                                                <div class="flex items-center gap-1 px-2 py-1 rounded-lg text-xs md:text-sm font-semibold text-green-600 bg-green-100 text-green-600">
                                                                    +5.15%
                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-up-right h-3 w-3">
                                                                        <path d="M7 7h10v10"></path>
                                                                        <path d="M7 17 17 7"></path>
                                                                    </svg>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                            <div class="mt-4 md:mt-6 text-center">
                                                <a class="group inline-flex items-center gap-2 text-blue-600 hover:text-blue-700 font-medium transition-colors text-sm md:text-base" href="markets.php">
                                                    Tüm Piyasaları Görüntüle
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-right w-4 h-4 group-hover:translate-x-1 transition-transform">
                                                        <path d="M5 12h14"></path>
                                                        <path d="m12 5 7 7-7 7"></path>
                                                    </svg>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                    <!-- Market Ticker -->
                    <section class="py-6 border-y backdrop-blur-sm bg-gray-50/80 border-gray-200">
                        <div class="overflow-hidden">
                            <div id="tickerContainer" class="flex whitespace-nowrap animate-ticker">
                                <!-- Ticker items will be loaded dynamically -->
                            </div>
                        </div>
                    </section>

                    <!-- Features Section -->
                    <section class="py-16 md:py-24 lg:py-32 relative overflow-hidden">
                        <div class="container mx-auto px-4 md:px-6 relative z-10">
                            <div class="text-center mb-12 md:mb-16">
                                <div class="inline-flex items-center gap-2 bg-blue-100 border border-blue-200 rounded-full px-4 py-2 text-sm font-medium text-blue-700 mb-6 md:mb-8">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-award w-4 h-4">
                                        <path d="m15.477 12.89 1.515 8.526a.5.5 0 0 1-.81.47l-3.58-2.687a1 1 0 0 0-1.197 0l-3.586 2.686a.5.5 0 0 1-.81-.469l1.514-8.526"></path>
                                        <circle cx="12" cy="8" r="6"></circle>
                                    </svg>
                                    Neden Bizi Seçmelisiniz
                                </div>
                                <div class="text-3xl md:text-4xl lg:text-5xl font-bold mb-4 md:mb-6">
                                    <span class="text-blue-600">Profesyonel Trader'lar</span> İçin Yapıldı
                                </div>
                                <div class="text-lg md:text-xl max-w-3xl mx-auto leading-relaxed text-gray-600">
                                    En gelişmiş işlem platformunu deneyimleyin. Eşsiz güvenlik ve her seviyeden trader için profesyonel kalitede araçlarla donatılmıştır.
                                </div>
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
                                <div class="group relative overflow-hidden rounded-2xl p-8 border transition-all duration-500 hover:scale-105 cursor-pointer bg-white border-gray-200">
                                    <div class="relative z-10">
                                        <div class="w-16 h-16 rounded-2xl flex items-center justify-center mb-6 bg-yellow-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-zap h-8 w-8 text-white">
                                                <path d="M4 14a1 1 0 0 1-.78-1.63l9.9-10.2a.5.5 0 0 1 .86.46l-1.92 6.02A1 1 0 0 0 13 10h7a1 1 0 0 1 .78 1.63l-9.9 10.2a.5.5 0 0 1-.86-.46l1.92-6.02A1 1 0 0 0 11 14z"></path>
                                            </svg>
                                        </div>
                                        <h3 class="text-xl font-bold mb-4 group-hover:text-blue-600 transition-colors">Hızlı İşlem</h3>
                                        <p class="leading-relaxed text-gray-600">Güvenilir eşleştirme motoru ve duyarlı işlem arayüzü ile işlemlerinizi hızla gerçekleştirin.</p>
                                    </div>
                                </div>
                                <div class="group relative overflow-hidden rounded-2xl p-8 border transition-all duration-500 hover:scale-105 cursor-pointer bg-white border-gray-200">
                                    <div class="relative z-10">
                                        <div class="w-16 h-16 rounded-2xl flex items-center justify-center mb-6 bg-green-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-shield h-8 w-8 text-white">
                                                <path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"></path>
                                            </svg>
                                        </div>
                                        <h3 class="text-xl font-bold mb-4 group-hover:text-blue-600 transition-colors">Güvenli Platform</h3>
                                        <p class="leading-relaxed text-gray-600">Varlıklarınızı korumak için şifreleme, güvenli cüzdanlar ve kimlik doğrulama protokolleri ile çok katmanlı güvenlik.</p>
                                    </div>
                                </div>
                                <div class="group relative overflow-hidden rounded-2xl p-8 border transition-all duration-500 hover:scale-105 cursor-pointer bg-white border-gray-200">
                                    <div class="relative z-10">
                                        <div class="w-16 h-16 rounded-2xl flex items-center justify-center mb-6 bg-blue-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chart-column h-8 w-8 text-white">
                                                <path d="M3 3v16a2 2 0 0 0 2 2h16"></path>
                                                <path d="M18 17V9"></path>
                                                <path d="M13 17V5"></path>
                                                <path d="M8 17v-3"></path>
                                            </svg>
                                        </div>
                                        <h3 class="text-xl font-bold mb-4 group-hover:text-blue-600 transition-colors">Gerçek Zamanlı Grafikler</h3>
                                        <p class="leading-relaxed text-gray-600">Bilgili işlem kararları için teknik göstergeler ve piyasa verileri ile profesyonel grafik araçları.</p>
                                    </div>
                                </div>
                                <div class="group relative overflow-hidden rounded-2xl p-8 border transition-all duration-500 hover:scale-105 cursor-pointer bg-white border-gray-200">
                                    <div class="relative z-10">
                                        <div class="w-16 h-16 rounded-2xl flex items-center justify-center mb-6 bg-purple-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-users h-8 w-8 text-white">
                                                <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                                                <circle cx="9" cy="7" r="4"></circle>
                                                <path d="M22 21v-2a4 4 0 0 0-3-3.87"></path>
                                                <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                                            </svg>
                                        </div>
                                        <h3 class="text-xl font-bold mb-4 group-hover:text-blue-600 transition-colors">Kullanıcı Topluluğu</h3>
                                        <p class="leading-relaxed text-gray-600">İşlem topluluğumuza katılın ve diğer trader'larla bağlantı kurarak içgörüler ve stratejiler paylaşın.</p>
                                    </div>
                                </div>
                                <div class="group relative overflow-hidden rounded-2xl p-8 border transition-all duration-500 hover:scale-105 cursor-pointer bg-white border-gray-200">
                                    <div class="relative z-10">
                                        <div class="w-16 h-16 rounded-2xl flex items-center justify-center mb-6 bg-red-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-target h-8 w-8 text-white">
                                                <circle cx="12" cy="12" r="10"></circle>
                                                <circle cx="12" cy="12" r="6"></circle>
                                                <circle cx="12" cy="12" r="2"></circle>
                                            </svg>
                                        </div>
                                        <h3 class="text-xl font-bold mb-4 group-hover:text-blue-600 transition-colors">Emir Türleri</h3>
                                        <p class="leading-relaxed text-gray-600">Esnek işlem stratejileri için piyasa, limit ve stop emirleri dahil çeşitli emir türleri.</p>
                                    </div>
                                </div>
                                <div class="group relative overflow-hidden rounded-2xl p-8 border transition-all duration-500 hover:scale-105 cursor-pointer bg-white border-gray-200">
                                    <div class="relative z-10">
                                        <div class="w-16 h-16 rounded-2xl flex items-center justify-center mb-6 bg-indigo-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-dollar-sign h-8 w-8 text-white">
                                                <line x1="12" x2="12" y1="2" y2="22"></line>
                                                <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
                                            </svg>
                                        </div>
                                        <h3 class="text-xl font-bold mb-4 group-hover:text-blue-600 transition-colors">Rekabetçi Ücretler</h3>
                                        <p class="leading-relaxed text-gray-600">Hem maker hem de taker'lar için rekabetçi oranlarla şeffaf ücret yapısı.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                    <!-- Global Platform Section -->
                    <section class="py-16 md:py-24 lg:py-32 relative overflow-hidden bg-gray-50">
                        <div class="container mx-auto px-4 md:px-6">
                            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 md:gap-16 items-center">
                                <div class="">
                                    <div class="inline-flex items-center gap-2 bg-blue-100 border border-blue-200 rounded-full px-4 py-2 text-sm font-medium text-blue-700 mb-8">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-globe w-4 h-4">
                                            <circle cx="12" cy="12" r="10"></circle>
                                            <path d="M12 2a14.5 14.5 0 0 0 0 20 14.5 14.5 0 0 0 0-20"></path>
                                            <path d="M2 12h20"></path>
                                        </svg>
                                        Küresel Platform
                                    </div>
                                    <div class="text-4xl md:text-5xl font-bold mb-6">
                                        Güvenilir <span class="text-blue-600">İşlem Platformu</span>
                                    </div>
                                    <div class="text-xl mb-8 leading-relaxed text-gray-600">
                                        Gelişmiş güvenlik önlemleri ve profesyonel araçlarla güvenli kripto para işlemleri deneyimleyin.
                                    </div>
                                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-6 mb-8">
                                        <div class="flex items-center gap-4 p-4 rounded-xl border bg-white border-gray-200">
                                            <div class="w-12 h-12 rounded-xl bg-blue-500 flex items-center justify-center">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-users w-6 h-6 text-white">
                                                    <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                                                    <circle cx="9" cy="7" r="4"></circle>
                                                    <path d="M22 21v-2a4 4 0 0 0-3-3.87"></path>
                                                    <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                                                </svg>
                                            </div>
                                            <div>
                                                <div class="font-semibold text-gray-900">Kullanıcı Dostu</div>
                                                <div class="text-sm text-gray-500">Kolay Arayüz</div>
                                            </div>
                                        </div>
                                        <div class="flex items-center gap-4 p-4 rounded-xl border bg-white border-gray-200">
                                            <div class="w-12 h-12 rounded-xl bg-blue-500 flex items-center justify-center">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-globe w-6 h-6 text-white">
                                                    <circle cx="12" cy="12" r="10"></circle>
                                                    <path d="M12 2a14.5 14.5 0 0 0 0 20 14.5 14.5 0 0 0 0-20"></path>
                                                    <path d="M2 12h20"></path>
                                                </svg>
                                            </div>
                                            <div>
                                                <div class="font-semibold text-gray-900">Küresel Erişim</div>
                                                <div class="text-sm text-gray-500">Her Yerden İşlem</div>
                                            </div>
                                        </div>
                                        <div class="flex items-center gap-4 p-4 rounded-xl border bg-white border-gray-200">
                                            <div class="w-12 h-12 rounded-xl bg-blue-500 flex items-center justify-center">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-shield w-6 h-6 text-white">
                                                    <path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"></path>
                                                </svg>
                                            </div>
                                            <div>
                                                <div class="font-semibold text-gray-900">Güvenli İşlem</div>
                                                <div class="text-sm text-gray-500">Korunan Varlıklar</div>
                                            </div>
                                        </div>
                                        <div class="flex items-center gap-4 p-4 rounded-xl border bg-white border-gray-200">
                                            <div class="w-12 h-12 rounded-xl bg-blue-500 flex items-center justify-center">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-award w-6 h-6 text-white">
                                                    <path d="m15.477 12.89 1.515 8.526a.5.5 0 0 1-.81.47l-3.58-2.687a1 1 0 0 0-1.197 0l-3.586 2.686a.5.5 0 0 1-.81-.469l1.514-8.526"></path>
                                                    <circle cx="12" cy="8" r="6"></circle>
                                                </svg>
                                            </div>
                                            <div>
                                                <div class="font-semibold text-gray-900">Kaliteli Hizmet</div>
                                                <div class="text-sm text-gray-500">7/24 Destek</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="relative">
                                    <div class="relative rounded-3xl p-8 border shadow-2xl bg-white border-gray-200">
                                        <div class="relative z-10">
                                            <h3 class="text-2xl font-bold mb-6 text-gray-900">Platform Özellikleri</h3>
                                            <div class="space-y-4">
                                                <div class="flex items-center gap-3">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check-big w-5 h-5 text-green-500 flex-shrink-0">
                                                        <path d="M21.801 10A10 10 0 1 1 17 3.335"></path>
                                                        <path d="m9 11 3 3L22 4"></path>
                                                    </svg>
                                                    <span class="text-gray-700">Gerçek zamanlı piyasa verileri ve fiyat beslemeleri</span>
                                                </div>
                                                <div class="flex items-center gap-3">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check-big w-5 h-5 text-green-500 flex-shrink-0">
                                                        <path d="M21.801 10A10 10 0 1 1 17 3.335"></path>
                                                        <path d="m9 11 3 3L22 4"></path>
                                                    </svg>
                                                    <span class="text-gray-700">İşlem esnekliği için çoklu emir türleri</span>
                                                </div>
                                                <div class="flex items-center gap-3">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check-big w-5 h-5 text-green-500 flex-shrink-0">
                                                        <path d="M21.801 10A10 10 0 1 1 17 3.335"></path>
                                                        <path d="m9 11 3 3L22 4"></path>
                                                    </svg>
                                                    <span class="text-gray-700">Tüm cihazlar için duyarlı web arayüzü</span>
                                                </div>
                                                <div class="flex items-center gap-3">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check-big w-5 h-5 text-green-500 flex-shrink-0">
                                                        <path d="M21.801 10A10 10 0 1 1 17 3.335"></path>
                                                        <path d="m9 11 3 3L22 4"></path>
                                                    </svg>
                                                    <span class="text-gray-700">Müşteri desteği ve yardım kaynakları</span>
                                                </div>
                                                <div class="flex items-center gap-3">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check-big w-5 h-5 text-green-500 flex-shrink-0">
                                                        <path d="M21.801 10A10 10 0 1 1 17 3.335"></path>
                                                        <path d="m9 11 3 3L22 4"></path>
                                                    </svg>
                                                    <span class="text-gray-700">Güvenli cüzdan ve hesap yönetimi</span>
                                                </div>
                                                <div class="flex items-center gap-3">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check-big w-5 h-5 text-green-500 flex-shrink-0">
                                                        <path d="M21.801 10A10 10 0 1 1 17 3.335"></path>
                                                        <path d="m9 11 3 3L22 4"></path>
                                                    </svg>
                                                    <span class="text-gray-700">Profesyonel grafik ve analiz araçları</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                    <!-- Get Started Section -->
                    <section class="py-16 md:py-24 lg:py-32">
                        <div class="container mx-auto px-4 md:px-6">
                            <div class="text-center mb-16">
                                <div class="inline-flex items-center gap-2 bg-blue-100 border border-blue-200 rounded-full px-4 py-2 text-sm font-medium text-blue-700 mb-8">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-target w-4 h-4">
                                        <circle cx="12" cy="12" r="10"></circle>
                                        <circle cx="12" cy="12" r="6"></circle>
                                        <circle cx="12" cy="12" r="2"></circle>
                                    </svg>
                                    Başlayın
                                </div>
                                <div class="text-4xl md:text-5xl font-bold mb-6">
                                    <span class="text-blue-600">İşlem Yolculuğunuza</span> Başlayın
                                </div>
                            </div>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                                <div class="group relative rounded-2xl p-8 border transition-all duration-500 hover:scale-[1.02] hover:shadow-2xl bg-white border-gray-200">
                                    <div class="relative z-10">
                                        <div class="flex items-center gap-4 mb-6">
                                            <div class="w-16 h-16 rounded-full flex items-center justify-center text-white bg-blue-500">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-users w-8 h-8">
                                                    <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                                                    <circle cx="9" cy="7" r="4"></circle>
                                                    <path d="M22 21v-2a4 4 0 0 0-3-3.87"></path>
                                                    <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                                                </svg>
                                            </div>
                                            <div class="text-4xl font-bold text-gray-700">01</div>
                                        </div>
                                        <h3 class="text-xl font-bold mb-4 group-hover:text-blue-600 transition-colors duration-300">Hesap Oluşturun</h3>
                                        <p class="leading-relaxed text-gray-600">E-posta doğrulaması ve güvenli şifre kurulumu ile ücretsiz işlem hesabınızı oluşturun.</p>
                                    </div>
                                </div>
                                <div class="group relative rounded-2xl p-8 border transition-all duration-500 hover:scale-[1.02] hover:shadow-2xl bg-white border-gray-200">
                                    <div class="relative z-10">
                                        <div class="flex items-center gap-4 mb-6">
                                            <div class="w-16 h-16 rounded-full flex items-center justify-center text-white bg-purple-500">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-shield w-8 h-8">
                                                    <path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"></path>
                                                </svg>
                                            </div>
                                            <div class="text-4xl font-bold text-gray-700">02</div>
                                        </div>
                                        <h3 class="text-xl font-bold mb-4 group-hover:text-blue-600 transition-colors duration-300">Cüzdanınızı Güvenceye Alın</h3>
                                        <p class="leading-relaxed text-gray-600">Uygun kimlik doğrulama ve yedek kurtarma yöntemleri ile güvenli cüzdanınızı kurun.</p>
                                    </div>
                                </div>
                                <div class="group relative rounded-2xl p-8 border transition-all duration-500 hover:scale-[1.02] hover:shadow-2xl bg-white border-gray-200">
                                    <div class="relative z-10">
                                        <div class="flex items-center gap-4 mb-6">
                                            <div class="w-16 h-16 rounded-full flex items-center justify-center text-white bg-orange-500">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chart-column w-8 h-8">
                                                    <path d="M3 3v16a2 2 0 0 0 2 2h16"></path>
                                                    <path d="M18 17V9"></path>
                                                    <path d="M13 17V5"></path>
                                                    <path d="M8 17v-3"></path>
                                                </svg>
                                            </div>
                                            <div class="text-4xl font-bold text-gray-700">03</div>
                                        </div>
                                        <h3 class="text-xl font-bold mb-4 group-hover:text-blue-600 transition-colors duration-300">İşlem Yapmaya Başlayın</h3>
                                        <p class="leading-relaxed text-gray-600">Piyasaları keşfedin, grafikleri analiz edin ve sezgisel platformumuzla ilk işlemlerinizi gerçekleştirin.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                    <!-- Mobile App Section -->
                    <section class="py-16 md:py-24 lg:py-32 relative overflow-hidden bg-white">
                        <div class="container mx-auto px-4 md:px-6 relative z-10">
                            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-20 items-center">
                                <div class="order-2 lg:order-1">
                                    <div class="inline-flex items-center gap-2 bg-blue-100 border border-blue-200 rounded-full px-4 py-2 text-sm font-medium text-blue-700 mb-8">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-smartphone w-4 h-4">
                                            <rect width="14" height="20" x="5" y="2" rx="2" ry="2"></rect>
                                            <path d="M12 18h.01"></path>
                                        </svg>
                                        Uygulamamızı İndirin
                                    </div>
                                    <h2 class="text-4xl md:text-5xl lg:text-6xl font-bold mb-6">
                                        Her Yerde İşlem Yapın
                                        <span class="block text-blue-600">İstediğiniz Zaman, İstediğiniz Yer</span>
                                    </h2>
                                    <p class="text-lg md:text-xl mb-8 leading-relaxed text-gray-600">
                                        Mobil uygulamamızla kesintisiz kripto para işlemleri yapın. Gerçek zamanlı piyasa verileri, güvenli işlemler ve profesyonel işlem araçlarını cebinizde taşıyın.
                                    </p>
                                    <div class="grid grid-cols-1 sm:grid-cols-3 gap-6 mb-10">
                                        <div class="text-center">
                                            <div class="w-12 h-12 bg-blue-500 rounded-xl flex items-center justify-center mx-auto mb-3">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-shield w-6 h-6 text-white">
                                                    <path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"></path>
                                                </svg>
                                            </div>
                                            <h3 class="font-semibold mb-1 text-gray-900">Güvenli İşlem</h3>
                                            <p class="text-sm text-gray-500">Banka seviyesi güvenlik</p>
                                        </div>
                                        <div class="text-center">
                                            <div class="w-12 h-12 bg-blue-500 rounded-xl flex items-center justify-center mx-auto mb-3">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-zap w-6 h-6 text-white">
                                                    <path d="M4 14a1 1 0 0 1-.78-1.63l9.9-10.2a.5.5 0 0 1 .86.46l-1.92 6.02A1 1 0 0 0 13 10h7a1 1 0 0 1 .78 1.63l-9.9 10.2a.5.5 0 0 1-.86-.46l1.92-6.02A1 1 0 0 0 11 14z"></path>
                                                </svg>
                                            </div>
                                            <h3 class="font-semibold mb-1 text-gray-900">Şimşek Hızında</h3>
                                            <p class="text-sm text-gray-500">Anında işlemler</p>
                                        </div>
                                        <div class="text-center">
                                            <div class="w-12 h-12 bg-blue-500 rounded-xl flex items-center justify-center mx-auto mb-3">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-star w-6 h-6 text-white">
                                                    <path d="M11.525 2.295a.53.53 0 0 1 .95 0l2.31 4.679a2.123 2.123 0 0 0 1.595 1.16l5.166.756a.53.53 0 0 1 .294.904l-3.736 3.638a2.123 2.123 0 0 0-.611 1.878l.882 5.14a.53.53 0 0 1-.771.56l-4.618-2.428a2.122 2.122 0 0 0-1.973 0L6.396 21.01a.53.53 0 0 1-.77-.56l.881-5.139a2.122 2.122 0 0 0-.611-1.879L2.16 9.795a.53.53 0 0 1 .294-.906l5.165-.755a2.122 2.122 0 0 0 1.597-1.16z"></path>
                                                </svg>
                                            </div>
                                            <h3 class="font-semibold mb-1 text-gray-900">Kullanıcı Dostu</h3>
                                            <p class="text-sm text-gray-500">Sezgisel arayüz</p>
                                        </div>
                                    </div>
                                    <div class="flex flex-col sm:flex-row gap-4">
                                        <a href="https://demo.mashdiv.com" target="_blank" rel="noopener noreferrer" class="group relative inline-flex items-center justify-center gap-3 bg-black hover:bg-gray-800 text-white px-6 py-4 rounded-2xl font-medium transition-all duration-300 hover:scale-105 hover:shadow-xl">
                                            <div class="w-8 h-8 relative">
                                                <svg viewBox="0 0 24 24" fill="currentColor" class="w-full h-full">
                                                    <path d="M18.71 19.5c-.83 1.24-1.71 2.45-3.05 2.47-1.34.03-1.77-.79-3.29-.79-1.53 0-2 .77-3.27.82-1.31.05-2.3-1.32-3.14-2.53C4.25 17 2.94 12.45 4.7 9.39c.87-1.52 2.43-2.48 4.12-2.51 1.28-.02 2.5.87 3.29.87.78 0 2.26-1.07 3.81-.91.65.03 2.47.26 3.64 1.98-.09.06-2.17 1.28-2.15 3.81.03 3.02 2.65 4.03 2.68 4.04-.03.07-.42 1.44-1.38 2.83M13 3.5c.73-.83 1.94-1.46 2.94-1.5.13 1.17-.34 2.35-1.04 3.19-.69.85-1.83 1.51-2.95 1.42-.15-1.15.41-2.35 1.05-3.11z"></path>
                                                </svg>
                                            </div>
                                            <div class="text-left">
                                                <div class="text-xs opacity-75">İndir</div>
                                                <div class="text-lg font-semibold">App Store</div>
                                            </div>
                                        </a>
                                        <a href="https://demo.mashdiv.com" target="_blank" rel="noopener noreferrer" class="group relative inline-flex items-center justify-center gap-3 bg-black hover:bg-gray-800 text-white px-6 py-4 rounded-2xl font-medium transition-all duration-300 hover:scale-105 hover:shadow-xl">
                                            <div class="w-8 h-8 relative">
                                                <svg viewBox="0 0 24 24" fill="currentColor" class="w-full h-full">
                                                    <path d="M3,20.5V3.5C3,2.91 3.34,2.39 3.84,2.15L13.69,12L3.84,21.85C3.34,21.6 3,21.09 3,20.5M16.81,15.12L6.05,21.34L14.54,12.85L16.81,15.12M20.16,10.81C20.5,11.08 20.75,11.5 20.75,12C20.75,12.5 20.53,12.9 20.18,13.18L17.89,14.5L15.39,12L17.89,9.5L20.16,10.81M6.05,2.66L16.81,8.88L14.54,11.15L6.05,2.66Z"></path>
                                                </svg>
                                            </div>
                                            <div class="text-left">
                                                <div class="text-xs opacity-75">Google Play'de</div>
                                                <div class="text-lg font-semibold">Alın</div>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                <div class="order-1 lg:order-2 flex justify-center">
                                    <div class="relative">
                                        <div class="relative w-80 h-[600px] bg-gray-900 rounded-[3rem] p-4 shadow-2xl">
                                            <div class="w-full h-full bg-blue-600 rounded-[2.5rem] overflow-hidden relative">
                                                <div class="absolute top-0 left-0 right-0 h-12 bg-black/20 flex items-center justify-between px-6 text-white text-sm">
                                                    <span>9:41</span>
                                                    <div class="flex items-center gap-1">
                                                        <div class="w-4 h-2 border border-white/50 rounded-sm">
                                                            <div class="w-3 h-1 bg-white rounded-sm"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="pt-12 p-6 h-full flex flex-col">
                                                    <div class="text-center text-white mb-8">
                                                        <h3 class="text-2xl font-bold mb-2">İşlem Paneli</h3>
                                                        <p class="text-white/80 text-sm">Portföy Bakiyesi</p>
                                                        <p class="text-3xl font-bold mt-2">$24,567.89</p>
                                                    </div>
                                                    <div class="bg-white/10 backdrop-blur-sm rounded-2xl p-4 mb-6 flex-1">
                                                        <div class="h-32 relative">
                                                            <svg class="w-full h-full" viewBox="0 0 300 120">
                                                                <path d="M 10 80 Q 50 60 100 70 T 200 50 T 290 30" stroke="white" stroke-width="3" fill="none" stroke-linecap="round"></path>
                                                                <defs>
                                                                    <linearGradient id="chartGradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                                                        <stop offset="0%" stop-color="white" stop-opacity="0.3"></stop>
                                                                        <stop offset="100%" stop-color="white" stop-opacity="0"></stop>
                                                                    </linearGradient>
                                                                </defs>
                                                                <path d="M 10 80 Q 50 60 100 70 T 200 50 T 290 30 L 290 120 L 10 120 Z" fill="url(#chartGradient)"></path>
                                                            </svg>
                                                        </div>
                                                    </div>
                                                    <div class="grid grid-cols-2 gap-3">
                                                        <div class="bg-white/10 backdrop-blur-sm rounded-xl p-3 text-center">
                                                            <div class="text-white/80 text-xs mb-1">Al</div>
                                                            <div class="text-white font-semibold">BTC</div>
                                                        </div>
                                                        <div class="bg-white/10 backdrop-blur-sm rounded-xl p-3 text-center">
                                                            <div class="text-white/80 text-xs mb-1">Sat</div>
                                                            <div class="text-white font-semibold">ETH</div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="absolute bottom-2 left-1/2 transform -translate-x-1/2 w-32 h-1 bg-white/30 rounded-full"></div>
                                            </div>
                                        </div>
                                        <div class="absolute -top-4 -right-4 w-16 h-16 bg-green-500 rounded-2xl flex items-center justify-center shadow-xl">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-download w-8 h-8 text-white">
                                                <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                                                <polyline points="7 10 12 15 17 10"></polyline>
                                                <line x1="12" x2="12" y1="15" y2="3"></line>
                                            </svg>
                                        </div>
                                        <div class="absolute -bottom-4 -left-4 w-20 h-12 bg-blue-500 rounded-xl flex items-center justify-center shadow-xl">
                                            <div class="text-white text-xs font-bold">24/7</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                    <!-- CTA Section -->
                    <section class="py-16 md:py-24 lg:py-32 relative overflow-hidden bg-gray-50">
                        <div class="container mx-auto px-4 md:px-6 relative z-10 text-center">
                            <div class="inline-flex items-center gap-2 bg-blue-100 border border-blue-200 rounded-full px-4 py-2 text-sm font-medium text-blue-700 mb-8">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-sparkles w-4 h-4">
                                    <path d="M9.937 15.5A2 2 0 0 0 8.5 14.063l-6.135-1.582a.5.5 0 0 1 0-.962L8.5 9.936A2 2 0 0 0 9.937 8.5l1.582-6.135a.5.5 0 0 1 .963 0L14.063 8.5A2 2 0 0 0 15.5 9.937l6.135 1.581a.5.5 0 0 1 0 .964L15.5 14.063a2 2 0 0 0-1.437 1.437l-1.582 6.135a.5.5 0 0 1-.963 0z"></path>
                                    <path d="M20 3v4"></path>
                                    <path d="M22 5h-4"></path>
                                    <path d="M4 17v2"></path>
                                    <path d="M5 18H3"></path>
                                </svg>
                                Yolculuğunuza Başlayın
                            </div>
                            <div class="text-4xl md:text-6xl font-bold mb-6 text-gray-900">
                                İşlem Yapmaya Hazır mısınız?
                            </div>
                            <div class="text-xl md:text-2xl mb-12 max-w-3xl mx-auto text-gray-600 leading-relaxed">
                                Platformumuza katılın ve profesyonel araçlar ve gerçek zamanlı piyasa verileri ile güvenli kripto para işlemi deneyimleyin.
                            </div>
                            <div class="flex flex-col sm:flex-row gap-4 justify-center items-center">
                                <a class="group px-8 py-4 bg-blue-600 text-white hover:bg-blue-700 rounded-2xl font-semibold transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105 flex items-center gap-2" href="register.php">
                                    Ücretsiz Hesap Oluştur
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-right w-5 h-5 group-hover:translate-x-1 transition-transform">
                                        <path d="M5 12h14"></path>
                                        <path d="m12 5 7 7-7 7"></path>
                                    </svg>
                                </a>
                                <div class="flex items-center gap-4 text-gray-600">
                                    <div class="flex items-center gap-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check-big w-5 h-5 text-green-500">
                                            <path d="M21.801 10A10 10 0 1 1 17 3.335"></path>
                                            <path d="m9 11 3 3L22 4"></path>
                                        </svg>
                                        <span>Kredi Kartı Gerekli Değil</span>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check-big w-5 h-5 text-green-500">
                                            <path d="M21.801 10A10 10 0 1 1 17 3.335"></path>
                                            <path d="m9 11 3 3L22 4"></path>
                                        </svg>
                                        <span>Ücretsiz Kayıt</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
            </main>
    
    <?php include 'components/footer.php'; ?>

    <?php
    function findCoinImage($symbol) {
        $dir = __DIR__ . '/assets/uploads/coins';
        if (!is_dir($dir)) return '';
        $files = @scandir($dir) ?: [];
        foreach ($files as $f) {
            if ($f === '.' || $f === '..') continue;
            if (stripos($f, $symbol) !== false) {
                return 'assets/uploads/coins/' . $f;
            }
        }
        // common readable names
        $map = [
            'BTC' => 'bitcoin',
            'ETH' => 'ethereum',
            'SOL' => 'solana',
            'XRP' => 'xrp',
            'USDC' => 'usdc',
            'USDT' => 'usdt'
        ];
        if (isset($map[$symbol])) {
            foreach (['.png','.svg','.webp','.jpg','.jpeg'] as $ext) {
                $p = $dir . '/' . $map[$symbol] . $ext;
                if (file_exists($p)) return 'assets/uploads/coins/' . $map[$symbol] . $ext;
            }
        }
        return '';
    }
    ?>
    <script>
        // Load real-time crypto prices
        async function loadCryptoPrices() {
            try {
                const response = await fetch('assets/crypto_prices.json');
                const data = await response.json();
                
                if (data && data.prices) {
                    // Update ticker
                    updateTicker(data.prices);
                    
                    // Update BTC
                    if (data.prices.BTC) {
                        updateCoinPrice('BTC', data.prices.BTC);
                    }
                    // Update ETH
                    if (data.prices.ETH) {
                        updateCoinPrice('ETH', data.prices.ETH);
                    }
                    // Update USDC
                    if (data.prices.USDC || data.prices.USDT) {
                        updateCoinPrice('USDC', data.prices.USDC || data.prices.USDT);
                    }
                    // Update SOL
                    if (data.prices.SOL) {
                        updateCoinPrice('SOL', data.prices.SOL);
                    }
                    // Update XRP
                    if (data.prices.XRP) {
                        updateCoinPrice('XRP', data.prices.XRP);
                    }
                }
            } catch (error) {
                console.error('Fiyatlar yüklenemedi:', error);
            }
        }

        function updateCoinPrice(symbol, data) {
            const isPositive = parseFloat(data.raw_change) >= 0;
            const colorClass = isPositive ? 'text-green-600 bg-green-100' : 'text-red-600 bg-red-100';
            const sign = isPositive ? '+' : '';
            
            // Logo: yalnızca data.image varsa kullan; yoksa rozet bırak
            
            // Price format
            const price = parseFloat(data.raw_price);
            let formattedPrice = '$' + price.toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2});
            if (price >= 1000000) {
                formattedPrice = '$' + (price / 1000000).toFixed(2) + 'M';
            } else if (price >= 1000) {
                formattedPrice = '$' + (price / 1000).toFixed(2) + 'K';
            }
            
            // Update the coin card
            const card = document.querySelector(`a[href="trade.php?symbol=${symbol}-USDT"]`);
            if (card) {
                // Find logo container by going through DOM structure (first column -> logo div)
                const firstCol = card.querySelector('.col-span-1');
                const logoWrap = firstCol ? firstCol.querySelector('div[class*="rounded-full"]') : null;
                const setLogo = (url) => { 
                    if (logoWrap && url) { 
                        logoWrap.innerHTML = `<img alt="${symbol}" class="w-6 h-6 md:w-8 md:h-8 object-cover rounded-full" src="${url}">`; 
                    } 
                };
                if (logoWrap) {
                    if (data.image && data.image.trim() !== '') {
                        setLogo(data.image);
                    } else {
                        // Try admin uploads without causing console spam: probe with fetch
                        const candidates = [
                            `assets/uploads/coins/${symbol.toLowerCase()}.png`,
                            `assets/uploads/coins/${symbol.toLowerCase()}.svg`,
                            `assets/uploads/coins/${symbol.toUpperCase()}.png`,
                            `assets/uploads/coins/${symbol.toUpperCase()}.svg`
                        ];
                        (async () => {
                            for (const u of candidates) {
                                try {
                                    const r = await fetch(u, { method: 'HEAD' });
                                    if (r.ok) { setLogo(u); break; }
                                } catch (_) { /* ignore */ }
                            }
                        })();
                    }
                }
                
                const priceDiv = card.querySelector('.col-span-1:nth-child(2) .font-mono');
                if (priceDiv) {
                    priceDiv.textContent = formattedPrice;
                }
                
                const changeDiv = card.querySelector('.col-span-1:nth-child(3) div.flex');
                if (changeDiv) {
                    changeDiv.className = `flex items-center gap-1 px-2 py-1 rounded-lg text-xs md:text-sm font-semibold ${colorClass}`;
                    changeDiv.innerHTML = `
                        ${sign}${data.raw_change.toFixed(2)}%
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-${isPositive ? 'up' : 'down'}-right h-3 w-3">
                            <path d="${isPositive ? 'M7 7h10v10' : 'm7 7 10 10'}"></path>
                            <path d="${isPositive ? 'M7 17 17 7' : 'M17 7v10H7'}"></path>
                        </svg>
                    `;
                }
            }
        }

        // Update ticker with real-time prices
        function updateTicker(prices) {
            const tickerContainer = document.getElementById('tickerContainer');
            if (!tickerContainer) return;
            
            const tickerItems = [
                { symbol: 'BTC', data: prices.BTC },
                { symbol: 'ETH', data: prices.ETH },
                { symbol: 'USDC', data: prices.USDC || prices.USDT },
                { symbol: 'SOL', data: prices.SOL },
                { symbol: 'XRP', data: prices.XRP }
            ];
            
            tickerContainer.innerHTML = '';
            
            // Create multiple copies for seamless looping
            for (let copy = 0; copy < 3; copy++) {
                tickerItems.forEach(item => {
                    if (item.data) {
                        const isPositive = parseFloat(item.data.raw_change) >= 0;
                        const colorClass = isPositive ? 'text-green-500' : 'text-red-500';
                        const sign = isPositive ? '+' : '';
                        
                        // Format price
                        const price = parseFloat(item.data.raw_price);
                        let formattedPrice = price.toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2});
                        if (price >= 1000 && price < 1000000) {
                            formattedPrice = (price / 1000).toFixed(2) + 'K';
                        } else if (price >= 1000000) {
                            formattedPrice = (price / 1000000).toFixed(2) + 'M';
                        }
                        
                        const tickerDiv = document.createElement('div');
                        tickerDiv.className = 'inline-flex items-center mx-6 text-gray-700';
                        tickerDiv.innerHTML = `
                            <div class="font-medium">${item.symbol}USDT</div>
                            <div class="mx-2 font-mono">${formattedPrice}</div>
                            <div class="flex items-center ${colorClass}">
                                <span>${sign}${item.data.raw_change.toFixed(2)}%</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-${isPositive ? 'up' : 'down'}-right h-3 w-3 ml-0.5 ${isPositive ? '' : 'rotate-180'}">
                                    <path d="${isPositive ? 'M7 7h10v10' : 'm7 7 10 10'}"></path>
                                    <path d="${isPositive ? 'M7 17 17 7' : 'M17 7v10H7'}"></path>
                                </svg>
                            </div>
                        `;
                        tickerContainer.appendChild(tickerDiv);
                    }
                });
            }
        }
        
        // Load prices on page load
        document.addEventListener('DOMContentLoaded', function() {
            loadCryptoPrices();
            // Update every 30 seconds
            setInterval(loadCryptoPrices, 30000);
        });
    </script>

</body>
</html>
