<?php
/**
 * Binance API'den gerçek trading verilerini getiren endpoint
 * Order Book, Recent Trades ve Price Data için
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type');

$symbol = $_GET['symbol'] ?? 'BTCUSDT';
$dataType = $_GET['type'] ?? 'all'; // all, orderbook, trades, price

try {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = [];
    
    // Price Data
    if ($dataType === 'all' || $dataType === 'price') {
        $url = "https://api.binance.com/api/v3/ticker/24hr?symbol={$symbol}";
        curl_setopt($ch, CURLOPT_URL, $url);
        $priceData = curl_exec($ch);
        
        if ($priceData) {
            $decoded = json_decode($priceData, true);
            if ($decoded && isset($decoded['lastPrice'])) {
                $response['price'] = [
                    'lastPrice' => floatval($decoded['lastPrice']),
                    'priceChange' => floatval($decoded['priceChange']),
                    'priceChangePercent' => floatval($decoded['priceChangePercent']),
                    'highPrice' => floatval($decoded['highPrice']),
                    'lowPrice' => floatval($decoded['lowPrice']),
                    'volume' => floatval($decoded['volume']),
                    'bidPrice' => floatval($decoded['bidPrice']),
                    'askPrice' => floatval($decoded['askPrice'])
                ];
            }
        }
    }
    
    // Order Book
    if ($dataType === 'all' || $dataType === 'orderbook') {
        $url = "https://api.binance.com/api/v3/depth?symbol={$symbol}&limit=20";
        curl_setopt($ch, CURLOPT_URL, $url);
        $orderBookData = curl_exec($ch);
        
        if ($orderBookData) {
            $decoded = json_decode($orderBookData, true);
            if ($decoded && isset($decoded['bids']) && isset($decoded['asks'])) {
                $response['orderbook'] = [
                    'bids' => array_slice($decoded['bids'], 0, 10), // İlk 10 alış emri
                    'asks' => array_slice($decoded['asks'], 0, 10)  // İlk 10 satış emri
                ];
            }
        }
    }
    
    // Recent Trades
    if ($dataType === 'all' || $dataType === 'trades') {
        $url = "https://api.binance.com/api/v3/trades?symbol={$symbol}&limit=20";
        curl_setopt($ch, CURLOPT_URL, $url);
        $tradesData = curl_exec($ch);
        
        if ($tradesData) {
            $decoded = json_decode($tradesData, true);
            if ($decoded && is_array($decoded)) {
                $response['trades'] = array_map(function($trade) {
                    return [
                        'price' => floatval($trade['price']),
                        'qty' => floatval($trade['qty']),
                        'time' => intval($trade['time']),
                        'isBuyer' => $trade['isBuyerMaker']
                    ];
                }, array_slice($decoded, 0, 15));
            }
        }
    }
    
    curl_close($ch);
    
    // Eğer veri yoksa hata döndür
    if (empty($response)) {
        echo json_encode(['error' => 'Veri alınamadı']);
    } else {
        echo json_encode($response);
    }
    
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>





