<header class="fixed top-0 left-0 right-0 z-50 transition-all duration-300 bg-gradient-to-b from-white/90 to-white/40 backdrop-blur-sm" style="opacity: 1; transform: none;">
    <div class="container mx-auto px-4 lg:px-6">
        <div class="flex items-center justify-between h-16">
            <!-- Logo Bölümü -->
            <div class="flex items-center gap-3 lg:gap-6">
                <div class="flex items-center gap-3">
                    <div class="relative" style="transform: none;">
                        <div class="flex items-center gap-3 min-w-0">
                            <!-- Mobile hamburger left of logo -->
                            <div class="md:hidden">
                                <button id="mobile-menu-button" onclick="toggleMobileMenu()" aria-expanded="false" aria-controls="mobile-menu" data-slot="button" class="inline-flex cursor-pointer items-center justify-center gap-2 whitespace-nowrap text-sm font-medium transition-[color,box-shadow] disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-hidden focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 aria-invalid:border-destructive relative h-11 w-11 hover:bg-primary/10 hover:text-primary text-foreground rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-menu h-7 w-7">
                                        <line x1="4" x2="20" y1="12" y2="12"></line>
                                        <line x1="4" x2="20" y1="6" y2="6"></line>
                                        <line x1="4" x2="20" y1="18" y2="18"></line>
                                    </svg>
                                </button>
                            </div>
                            <a class="text-primary flex items-center gap-3 min-w-0" href="/tr">
                                <div class="relative flex-shrink-0 h-9 lg:h-12 w-auto max-w-[220px] lg:max-w-[280px] object-contain flex-shrink-0">
                                    <img alt="Logo" loading="lazy" width="180" height="48" decoding="async" data-nimg="1" 
                                         class="h-9 lg:h-12 w-auto max-w-[220px] lg:max-w-[280px] object-contain flex-shrink-0" 
                                         src="https://demo.mashdiv.com/img/logo/logo-text-dark.webp?v=1" 
                                         style="color: transparent;">
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Navigasyon Menüsü (Desktop) -->
            <div class="ml-8 hidden md:block">
                <div>
                    <nav aria-label="Main" data-orientation="horizontal" dir="ltr" class="flex relative justify-start group">
                        <div style="position: relative;">
                            <ul data-orientation="horizontal" class="group flex list-none gap-5" dir="ltr">
                                <!-- Trading -->
                                <li>
                                    <div class="flex items-center py-4 cursor-pointer group transition hover:text-blue-600" 
                                         id="radix-_r_d_-trigger-user-trading" data-state="closed" aria-expanded="false" 
                                         aria-controls="radix-_r_d_-content-user-trading" data-radix-collection-item="">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" 
                                             aria-hidden="true" role="img" class="iconify iconify--solar h-5 w-5 mr-2" 
                                             width="1em" height="1em" viewBox="0 0 24 24">
                                            <path fill="currentColor" d="M3.293 9.293C3 9.586 3 10.057 3 11v6c0 .943 0 1.414.293 1.707S4.057 19 5 19s1.414 0 1.707-.293S7 17.943 7 17v-6c0-.943 0-1.414-.293-1.707S5.943 9 5 9s-1.414 0-1.707.293"></path>
                                            <path fill="currentColor" d="M17.293 2.293C17 2.586 17 3.057 17 4v13c0 .943 0 1.414.293 1.707S18.057 19 19 19s1.414 0 1.707-.293S21 17.943 21 17V4c0-.943 0-1.414-.293-1.707S19.943 2 19 2s-1.414 0-1.707.293" opacity=".4"></path>
                                            <path fill="currentColor" d="M10 7c0-.943 0-1.414.293-1.707S11.057 5 12 5s1.414 0 1.707.293S14 6.057 14 7v10c0 .943 0 1.414-.293 1.707S12.943 19 12 19s-1.414 0-1.707-.293S10 17.943 10 17z" opacity=".7"></path>
                                            <path fill="currentColor" d="M3 21.25a.75.75 0 0 0 0 1.5h18a.75.75 0 0 0 0-1.5z"></path>
                                        </svg>
                                        <span class="text-sm font-medium text-gray-700">İşlem</span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" 
                                             stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" 
                                             class="lucide lucide-chevron-down relative top-[1px] ml-1 h-4 w-4 transition duration-200 group-data-[state=open]:rotate-180" 
                                             aria-hidden="true">
                                            <path d="m6 9 6 6 6-6"></path>
                                        </svg>
                                    </div>
                                    <!-- Trading Dropdown -->
                                    <div id="radix-_r_d_-content-user-trading" class="dropdown-content hidden">
                                        <a href="trade.php">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m6 9 6 6 6-6"></path>
                                            </svg>
                                            Spot İşlem
                                        </a>
                                        <a href="futures.php">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m6 9 6 6 6-6"></path>
                                            </svg>
                                            Vadeli İşlem
                                        </a>
                                        <a href="markets.php">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m6 9 6 6 6-6"></path>
                                            </svg>
                                            Piyasalar
                                        </a>
                                        <a href="historical.php">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m6 9 6 6 6-6"></path>
                                            </svg>
                                            Geçmiş Veriler
                                        </a>
                                    </div>
                                </li>
                                
                                <!-- Portfolio -->
                                <li>
                                    <div class="flex items-center py-4 cursor-pointer group transition hover:text-blue-600" 
                                         id="radix-_r_d_-trigger-user-portfolio" data-state="closed" aria-expanded="false" 
                                         aria-controls="radix-_r_d_-content-user-portfolio" data-radix-collection-item="">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" 
                                             aria-hidden="true" role="img" class="iconify iconify--solar h-5 w-5 mr-2" 
                                             width="1em" height="1em" viewBox="0 0 24 24">
                                            <path fill="currentColor" d="M4.892 9.614c0-.402.323-.728.722-.728H9.47c.4 0 .723.326.723.728a.726.726 0 0 1-.723.729H5.614a.726.726 0 0 1-.722-.729"></path>
                                            <path fill="currentColor" fill-rule="evenodd" d="M21.188 10.004q-.094-.005-.2-.004h-2.773C15.944 10 14 11.736 14 14s1.944 4 4.215 4h2.773q.106.001.2-.004c.923-.056 1.739-.757 1.808-1.737c.004-.064.004-.133.004-.197v-4.124c0-.064 0-.133-.004-.197c-.069-.98-.885-1.68-1.808-1.737m-3.217 5.063c.584 0 1.058-.478 1.058-1.067c0-.59-.474-1.067-1.058-1.067s-1.06.478-1.06 1.067c0 .59.475 1.067 1.06 1.067" clip-rule="evenodd"></path>
                                            <path fill="currentColor" d="M21.14 10.002c0-1.181-.044-2.448-.798-3.355a4 4 0 0 0-.233-.256c-.749-.748-1.698-1.08-2.87-1.238C16.099 5 14.644 5 12.806 5h-2.112C8.856 5 7.4 5 6.26 5.153c-1.172.158-2.121.49-2.87 1.238c-.748.749-1.08 1.698-1.238 2.87C2 10.401 2 11.856 2 13.694v.112c0 1.838 0 3.294.153 4.433c.158 1.172.49 2.121 1.238 2.87c.749.748 1.698 1.08 2.87 1.238c1.14.153 2.595.153 4.433.153h2.112c1.838 0 3.294 0 4.433-.153c1.172-.158 2.121-.49 2.87-1.238q.305-.308.526-.66c.45-.72.504-1.602.504-2.45l-.15.001h-2.774C15.944 18 14 16.264 14 14s1.944-4 4.215-4h2.773q.079 0 .151.002" opacity=".5"></path>
                                            <path fill="currentColor" d="M10.101 2.572L8 3.992l-1.733 1.16C7.405 5 8.859 5 10.694 5h2.112c1.838 0 3.294 0 4.433.153q.344.045.662.114L16 4l-2.113-1.428a3.42 3.42 0 0 0-3.786 0"></path>
                                        </svg>
                                        <span class="text-sm font-medium text-gray-700">Portföy</span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" 
                                             stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" 
                                             class="lucide lucide-chevron-down relative top-[1px] ml-1 h-4 w-4 transition duration-200 group-data-[state=open]:rotate-180" 
                                             aria-hidden="true">
                                            <path d="m6 9 6 6 6-6"></path>
                                        </svg>
                                    </div>
                                    <!-- Portfolio Dropdown -->
                                    <div id="radix-_r_d_-content-user-portfolio" class="dropdown-content hidden">
                                        <a href="portfolio.php">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                                            </svg>
                                            Portföy
                                        </a>
                                        <a href="wallet.php">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                                            </svg>
                                            Cüzdan
                                        </a>
                                        <a href="wallet-history.php">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                            </svg>
                                            Geçmiş
                                        </a>
                                    </div>
                                </li>
                                
                                <!-- Investments -->
                                <li>
                                    <div class="flex items-center py-4 cursor-pointer group transition hover:text-blue-600" 
                                         id="radix-_r_d_-trigger-user-investments" data-state="closed" aria-expanded="false" 
                                         aria-controls="radix-_r_d_-content-user-investments" data-radix-collection-item="">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" 
                                             aria-hidden="true" role="img" class="iconify iconify--solar h-5 w-5 mr-2" 
                                             width="1em" height="1em" viewBox="0 0 24 24">
                                            <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                                <path d="m22 7l-7.38 7.335c-.997.991-1.496 1.487-2.115 1.487s-1.117-.496-2.115-1.488l-.24-.238c-.997-.992-1.497-1.489-2.116-1.489s-1.118.497-2.115 1.49L2 18" opacity=".5"></path>
                                                <path d="M22 12.546V7h-5.582"></path>
                                            </g>
                                        </svg>
                                        <span class="text-sm font-medium text-gray-700">Yatırım</span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" 
                                             stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" 
                                             class="lucide lucide-chevron-down relative top-[1px] ml-1 h-4 w-4 transition duration-200 group-data-[state=open]:rotate-180" 
                                             aria-hidden="true">
                                            <path d="m6 9 6 6 6-6"></path>
                                        </svg>
                                    </div>
                                    <!-- Investments Dropdown -->
                                    <div id="radix-_r_d_-content-user-investments" class="dropdown-content hidden">
                                        <a href="staking.php">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m6 9 6 6 6-6"></path>
                                            </svg>
                                            Stake
                                        </a>
                                        <a href="lending.php">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m6 9 6 6 6-6"></path>
                                            </svg>
                                            Borç Verme
                                        </a>
                                        <a href="yield.php">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m6 9 6 6 6-6"></path>
                                            </svg>
                                            Yield Tarımı
                                        </a>
                                    </div>
                                </li>
                                
                                <!-- Marketplace -->
                                <li>
                                    <div class="flex items-center py-4 cursor-pointer group transition hover:text-blue-600" 
                                         id="radix-_r_d_-trigger-user-marketplace" data-state="closed" aria-expanded="false" 
                                         aria-controls="radix-_r_d_-content-user-marketplace" data-radix-collection-item="">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" 
                                             aria-hidden="true" role="img" class="iconify iconify--solar h-5 w-5 mr-2" 
                                             width="1em" height="1em" viewBox="0 0 24 24">
                                            <path fill="currentColor" d="M4.083 11.894c.439-2.34.658-3.511 1.491-4.203C6.408 7 7.598 7 9.98 7h4.04c2.383 0 3.573 0 4.407.691c.833.692 1.052 1.862 1.491 4.203l.75 4c.617 3.292.926 4.938.026 6.022S18.12 23 14.771 23H9.23c-3.349 0-5.024 0-5.923-1.084c-.9-1.084-.591-2.73.026-6.022z" opacity=".5"></path>
                                            <path fill="currentColor" d="M9.75 5.985a2.25 2.25 0 0 1 4.5 0v1c.566 0 1.062.002 1.5.015V5.985a3.75 3.75 0 1 0-7.5 0V7c.438-.013.934-.015 1.5-.015zm.128 9.765a2.251 2.251 0 0 0 4.245 0a.75.75 0 1 1 1.414.5a3.751 3.751 0 0 1-7.073 0a.75.75 0 0 1 1.414-.5"></path>
                                        </svg>
                                        <span class="text-sm font-medium text-gray-700">Pazar</span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" 
                                             stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" 
                                             class="lucide lucide-chevron-down relative top-[1px] ml-1 h-4 w-4 transition duration-200 group-data-[state=open]:rotate-180" 
                                             aria-hidden="true">
                                            <path d="m6 9 6 6 6-6"></path>
                                        </svg>
                                    </div>
                                    <!-- Marketplace Dropdown -->
                                    <div id="radix-_r_d_-content-user-marketplace" class="dropdown-content hidden">
                                        <a href="markets.php">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m6 9 6 6 6-6"></path>
                                            </svg>
                                            Piyasalar
                                        </a>
                                        <a href="historical.php">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m6 9 6 6 6-6"></path>
                                            </svg>
                                            Piyasa Analizi
                                        </a>
                                    </div>
                                </li>
                                
                                <!-- Services -->
                                <li>
                                    <div class="flex items-center py-4 cursor-pointer group transition hover:text-blue-600" 
                                         id="radix-_r_d_-trigger-user-services" data-state="closed" aria-expanded="false" 
                                         aria-controls="radix-_r_d_-content-user-services" data-radix-collection-item="">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" 
                                             aria-hidden="true" role="img" class="iconify iconify--solar h-5 w-5 mr-2" 
                                             width="1em" height="1em" viewBox="0 0 24 24">
                                            <path fill="currentColor" fill-rule="evenodd" d="M14.279 2.152C13.909 2 13.439 2 12.5 2s-1.408 0-1.779.152a2 2 0 0 0-1.09 1.083c-.094.223-.13.484-.145.863a1.62 1.62 0 0 1-.796 1.353a1.64 1.64 0 0 1-1.579.008c-.338-.178-.583-.276-.825-.308a2.03 2.03 0 0 0-1.49.396c-.318.242-.553.646-1.022 1.453c-.47.807-.704 1.21-.757 1.605c-.07.526.074 1.058.4 1.479c.148.192.357.353.68.555c.477.297.783.803.783 1.361s-.306 1.064-.782 1.36c-.324.203-.533.364-.682.556a2 2 0 0 0-.399 1.479c.053.394.287.798.757 1.605s.704 1.21 1.022 1.453c.424.323.96.465 1.49.396c.242-.032.487-.13.825-.308a1.64 1.64 0 0 1 1.58.008c.486.28.774.795.795 1.353c.015.38.051.64.145.863c.37.152.84.152 1.779.152s1.409 0 1.779-.152a2 2 0 0 0 1.09-1.083c.094-.223.13-.483.145-.863c.02-.558.309-1.074.796-1.353a1.64 1.64 0 0 1 1.579-.008c.338.178.583.276.825.308c.53.07 1.066-.073 1.49-.396c.318-.242.553-.646 1.022-1.453c.47-.807.704-1.21.757-1.605a2 2 0 0 0-.4-1.479c-.148-.192-.357-.353-.68-.555c-.477-.297-.783-.803-.783-1.361s.306-1.064.782-1.36c.324-.203.533-.364.682-.556a2 2 0 0 0 .399-1.479c-.053-.394-.287-.798-.757-1.605s-.704-1.21-1.022-1.453a2.03 2.03 0 0 0-1.49-.396c-.242.032-.487.13-.825.308a1.64 1.64 0 0 1-1.58-.008a1.62 1.62 0 0 1-.795-1.353c-.015-.38-.051-.64-.145-.863a2 2 0 0 0-1.09-1.083" clip-rule="evenodd" opacity=".5"></path>
                                            <path fill="currentColor" d="M15.523 12c0 1.657-1.354 3-3.023 3s-3.023-1.343-3.023-3S10.83 9 12.5 9s3.023 1.343 3.023 3"></path>
                                        </svg>
                                        <span class="text-sm font-medium text-gray-700">Hizmetler</span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" 
                                             stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" 
                                             class="lucide lucide-chevron-down relative top-[1px] ml-1 h-4 w-4 transition duration-200 group-data-[state=open]:rotate-180" 
                                             aria-hidden="true">
                                            <path d="m6 9 6 6 6-6"></path>
                                        </svg>
                                    </div>
                                    <!-- Services Dropdown -->
                                    <div id="radix-_r_d_-content-user-services" class="dropdown-content hidden">
                                        <a href="index.php">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m6 9 6 6 6-6"></path>
                                            </svg>
                                            API Dokümantasyonu
                                        </a>
                                        <a href="index.php">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m6 9 6 6 6-6"></path>
                                            </svg>
                                            Destek
                                        </a>
                                        <a href="index.php">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m6 9 6 6 6-6"></path>
                                            </svg>
                                            Yardım Merkezi
                                        </a>
                                    </div>
                                </li>
                                
                                <!-- Insights/Blog -->
                                <li>
                                    <a class="flex items-center py-4 cursor-pointer transition hover:text-blue-600" 
                                       data-radix-collection-item="" href="index.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" 
                                             aria-hidden="true" role="img" class="iconify iconify--fluent h-5 w-5 mr-2" 
                                             width="1em" height="1em" viewBox="0 0 28 28">
                                            <path fill="currentColor" d="M6.75 3A3.75 3.75 0 0 0 3 6.75v14.5A3.75 3.75 0 0 0 6.75 25h14.5A3.75 3.75 0 0 0 25 21.25V6.75A3.75 3.75 0 0 0 21.25 3zM4.5 6.75A2.25 2.25 0 0 1 6.75 4.5h14.5a2.25 2.25 0 0 1 2.25 2.25v14.5a2.25 2.25 0 0 1-2.25 2.25H6.75a2.25 2.25 0 0 1-2.25-2.25zM6 9a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2zm2-.5a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 .5.5h12a.5.5 0 0 0 .5-.5V9a.5.5 0 0 0-.5-.5zm-2 7.25a.75.75 0 0 1 .75-.75h5.5a.75.75 0 0 1 0 1.5h-5.5a.75.75 0 0 1-.75-.75m.75 3a.75.75 0 0 0 0 1.5h5.5a.75.75 0 0 0 0-1.5zm8.75-2.5c0-.966.784-1.75 1.75-1.75h3c.966 0 1.75.784 1.75 1.75v3A1.75 1.75 0 0 1 20.25 21h-3a1.75 1.75 0 0 1-1.75-1.75zm1.75-.25a.25.25 0 0 0-.25.25v3c0 .138.112.25.25.25h3a.25.25 0 0 0 .25-.25v-3a.25.25 0 0 0-.25-.25z"></path>
                                        </svg>
                                        <span class="text-sm font-medium text-gray-700">İçgörüler</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="absolute top-full"></div>
                    </nav>
                </div>
            </div>
            
            <!-- Sağ taraf - Dil seçimi ve Giriş/Kayıt butonları -->
            <div class="flex items-center gap-2 lg:gap-3">
                <!-- Dil seçimi -->
                <div class="hidden md:block">
                    <button class="flex items-center gap-2 p-2 rounded-full transition-colors text-zinc-600 hover:text-zinc-900 hover:bg-zinc-100 dark:text-zinc-400 dark:hover:text-zinc-100 dark:hover:bg-zinc-800" tabindex="0">
                        <div class="w-5 h-5 rounded-full overflow-hidden">
                            <img alt="TR" loading="lazy" width="20" height="20" decoding="async" 
                                 class="w-full h-full object-cover" src="assets/uploads/flags/tr.png">
                        </div>
                    </button>
                </div>
                
                <!-- Kullanıcı Profil Dropdown -->
                <div class="flex items-center">
                    <!-- Giriş yapmış kullanıcı için profil dropdown -->
                    <div id="user-profile" class="hidden relative">
                        <button onclick="toggleProfileDropdown()" 
                           class="flex items-center gap-2 p-2 rounded-full hover:bg-gray-100 transition-colors">
                            <div class="relative flex size-8 shrink-0 overflow-hidden rounded-full h-9 w-9 border-2 border-white shadow-sm">
                                <img id="user-avatar" class="aspect-square size-full" alt="Avatar" src="data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='80' height='80'><rect width='100%' height='100%' fill='%23e5e7eb'/><text x='50%' y='52%' dominant-baseline='middle' text-anchor='middle' fill='%239ca3af' font-family='Arial' font-size='28'>👤</text></svg>">
                            </div>
                            <span id="user-name" class="text-sm font-medium text-gray-700 hidden md:block">Test User</span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-chevron-down h-4 w-4 text-gray-500">
                                <path d="m6 9 6 6 6-6"></path>
                            </svg>
                        </button>
                        
                        <!-- Profile Dropdown Menu -->
                        <div id="profile-dropdown" class="absolute right-0 top-full mt-2 w-56 bg-white rounded-md border shadow-lg z-50 hidden">
                            <div class="py-1">
                                <!-- User Info -->
                                <div class="px-3 py-2 border-b">
                                    <div class="flex items-center gap-2">
                                        <div class="relative flex size-8 shrink-0 overflow-hidden rounded-full h-9 w-9 border-2 border-white shadow-sm">
                                            <img id="dropdown-avatar" class="aspect-square size-full" alt="Avatar" src="data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='80' height='80'><rect width='100%' height='100%' fill='%23e5e7eb'/><text x='50%' y='52%' dominant-baseline='middle' text-anchor='middle' fill='%239ca3af' font-family='Arial' font-size='28'>👤</text></svg>">
                                        </div>
                                        <div>
                                            <div id="dropdown-name" class="text-sm font-medium text-gray-900">Test User</div>
                                            <div id="dropdown-email" class="text-xs text-gray-500">test@test.com</div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Menu Items -->
                                <a href="profile.php" class="flex items-center gap-2 px-3 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 256 256" fill="currentColor" class="h-4 w-4">
                                        <path d="M224 128a95.76 95.76 0 0 1-31.8 71.37A72 72 0 0 0 128 160a40 40 0 1 0-40-40a40 40 0 0 0 40 40a72 72 0 0 0-64.2 39.37A96 96 0 1 1 224 128" opacity=".2"></path>
                                        <path d="M128 24a104 104 0 1 0 104 104A104.11 104.11 0 0 0 128 24M74.08 197.5a64 64 0 0 1 107.84 0a87.83 87.83 0 0 1-107.84 0M96 120a32 32 0 1 1 32 32a32 32 0 0 1-32-32m97.76 66.41a79.66 79.66 0 0 0-36.06-28.75a48 48 0 1 0-59.4 0a79.66 79.66 0 0 0-36.06 28.75a88 88 0 1 1 131.52 0"></path>
                                    </svg>
                                    Profil
                                </a>
                                <a href="wallet.php" class="flex items-center gap-2 px-3 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 256 256" fill="currentColor" class="h-4 w-4">
                                        <path fill="currentColor" d="M216 64H56a8 8 0 0 1 0-16h136a8 8 0 0 0 0-16H56a24 24 0 0 0-24 24v128a24 24 0 0 0 24 24h160a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16m0 128H56a8 8 0 0 1-8-8V78.63A23.8 23.8 0 0 0 56 80h160Zm-48-60a12 12 0 1 1 12 12a12 12 0 0 1-12-12"></path>
                                    </svg>
                                    Varlıklar
                                </a>
                                <a href="api-management.php" class="flex items-center gap-2 px-3 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 32 32" fill="currentColor" class="h-4 w-4">
                                        <path d="M26 22a3.86 3.86 0 0 0-2 .57l-3.09-3.1a6 6 0 0 0 0-6.94L24 9.43a3.86 3.86 0 0 0 2 .57a4 4 0 1 0-4-4a3.86 3.86 0 0 0 .57 2l-3.1 3.09a6 6 0 0 0-6.94 0L9.43 8A3.86 3.86 0 0 0 10 6a4 4 0 1 0-4 4a3.86 3.86 0 0 0 2-.57l3.09 3.1a6 6 0 0 0 0 6.94L8 22.57A3.86 3.86 0 0 0 6 22a4 4 0 1 0 4 4a3.86 3.86 0 0 0-.57-2l3.1-3.09a6 6 0 0 0 6.94 0l3.1 3.09a3.86 3.86 0 0 0-.57 2a4 4 0 1 0 4-4m0-18a2 2 0 1 1-2 2a2 2 0 0 1 2-2M4 6a2 2 0 1 1 2 2a2 2 0 0 1-2-2m2 22a2 2 0 1 1 2-2a2 2 0 0 1-2 2m10-8a4 4 0 1 1 4-4a4 4 0 0 1-4 4m10 8a2 2 0 1 1 2-2a2 2 0 0 1-2 2"></path>
                                    </svg>
                                    API Yönetimi
                                </a>
                                
                                <!-- Separator -->
                                <div class="border-t my-1"></div>
                                
                                <!-- Logout -->
                                <button onclick="logout()" class="flex items-center gap-2 px-3 py-2 text-sm text-gray-700 hover:bg-gray-100 w-full text-left">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 256 256" fill="currentColor" class="h-4 w-4">
                                        <path d="M216 96v112a8 8 0 0 1-8 8H48a8 8 0 0 1-8-8V96a8 8 0 0 1 8-8h160a8 8 0 0 1 8 8" opacity=".2"></path>
                                        <path d="M208 80h-32V56a48 48 0 0 0-96 0v24H48a16 16 0 0 0-16 16v112a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16V96a16 16 0 0 0-16-16M96 56a32 32 0 0 1 64 0v24H96Zm112 152H48V96h160zm-68-56a12 12 0 1 1-12-12a12 12 0 0 1 12 12"></path>
                                    </svg>
                                    Oturum kapatma
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Giriş yapmamış kullanıcı için -->
                    <div id="guest-buttons" class="md:flex items-center space-x-2" style="display: none;">
                        <button onclick="openLoginModal()" 
                           class="inline-flex cursor-pointer items-center justify-center gap-2 whitespace-nowrap transition-[color,box-shadow] disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-hidden focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive border border-input bg-background shadow-2xs hover:bg-accent hover:text-accent-foreground h-9 rounded-md px-3 py-1.5 text-xs font-medium min-w-0 flex-shrink-0">
                            <span class="hidden xs:inline">Giriş yap</span>
                            <span class="xs:hidden">Giriş yap</span>
                        </button>
                        <button onclick="openRegisterModal()" 
                           class="inline-flex cursor-pointer items-center justify-center gap-2 whitespace-nowrap transition-[color,box-shadow] disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-hidden focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive bg-primary text-primary-foreground shadow-2xs hover:bg-primary/90 h-9 rounded-md px-3 py-1.5 text-xs font-medium min-w-0 flex-shrink-0">
                            <span class="hidden xs:inline">Kaydol</span>
                            <span class="xs:hidden">Kaydol</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>

<!-- Mobile Drawer (from left) -->
<div id="mobile-menu-overlay" class="fixed inset-0 bg-black/50 backdrop-blur-sm z-[60] hidden" onclick="closeMobileMenu()"></div>
<aside id="mobile-menu" class="fixed inset-y-0 left-0 z-[61] w-[84vw] max-w-sm bg-white shadow-xl border-r border-zinc-200 transform -translate-x-full transition-transform duration-300 ease-in-out md:hidden">
    <div class="flex items-center justify-between h-14 px-4 border-b border-zinc-200">
        <a href="index.php" class="flex items-center gap-2 min-w-0">
            <img alt="Logo" src="https://demo.mashdiv.com/img/logo/logo-text-dark.webp?v=1" class="h-8 w-auto"/>
        </a>
        <button onclick="closeMobileMenu()" class="h-10 w-10 rounded-full hover:bg-zinc-100 flex items-center justify-center">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x h-5 w-5">
                <path d="M18 6 6 18"></path>
                <path d="m6 6 12 12"></path>
            </svg>
        </button>
    </div>

    <div class="overflow-y-auto h-[calc(100vh-56px)]">
        <!-- Auth/Profile -->
        <div id="mobile-guest-buttons" class="px-4 py-3" style="display: none;">
            <div class="grid grid-cols-2 gap-2">
                <button onclick="closeMobileMenu(); openLoginModal();" class="border border-input bg-background hover:bg-zinc-100 dark:hover:bg-zinc-800 rounded-md h-10 text-sm">Giriş yap</button>
                <button onclick="closeMobileMenu(); openRegisterModal();" class="bg-blue-600 text-white hover:bg-blue-700 rounded-md h-10 text-sm">Kaydol</button>
            </div>
        </div>
        <div id="mobile-user-profile" class="px-4 py-3 hidden">
            <div class="flex items-center gap-3">
                <img id="mobile-user-avatar" class="h-10 w-10 rounded-full border border-zinc-200" alt="Avatar" src="data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='80' height='80'><rect width='100%' height='100%' fill='%23e5e7eb'/><text x='50%' y='52%' dominant-baseline='middle' text-anchor='middle' fill='%239ca3af' font-family='Arial' font-size='28'>👤</text></svg>">
                <div class="min-w-0">
                    <div id="mobile-user-name" class="text-sm font-medium text-zinc-900 truncate">Kullanıcı</div>
                    <div id="mobile-user-email" class="text-xs text-zinc-500 truncate">email</div>
                </div>
            </div>
            <div class="mt-3 grid grid-cols-2 gap-2">
                <a href="profile.php" class="rounded-md h-10 text-sm flex items-center justify-center border hover:bg-zinc-100">Profil</a>
                <a href="wallet.php" class="rounded-md h-10 text-sm flex items-center justify-center border hover:bg-zinc-100">Varlıklar</a>
                <button onclick="logout()" class="col-span-2 bg-zinc-900 text-white hover:bg-zinc-800 rounded-md h-10 text-sm">Oturumu kapat</button>
            </div>
        </div>

        <!-- Sections (match design) -->
        <nav class="px-2 pb-6">
            <div data-radix-scroll-area-viewport data-slot="scroll-area-viewport" class="ring-ring/10 outline-ring/50 size-full rounded-[inherit] transition-[color,box-shadow] focus-visible:ring-4 focus-visible:outline-1" style="overflow: hidden scroll;">
                <div style="min-width: 100%; display: table;">
                    <ul dir="ltr" class="space-y-1">
                        <!-- Trading -->
                        <li>
                            <div class="flex text-foreground group font-medium text-sm capitalize px-[10px] py-3 rounded cursor-pointer transition-all duration-100 hover:bg-primary hover:text-primary-foreground" onclick="toggleMobileSection('trading')" aria-controls="mobile-sec-trading" aria-expanded="false">
                                <div class="flex-1 gap-3 flex items-start">
                                    <span class="inline-flex items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img" class="w-5 h-5" viewBox="0 0 24 24"><path fill="currentColor" d="M3.293 9.293C3 9.586 3 10.057 3 11v6c0 .943 0 1.414.293 1.707S4.057 19 5 19s1.414 0 1.707-.293S7 17.943 7 17v-6c0-.943 0-1.414-.293-1.707S5.943 9 5 9s-1.414 0-1.707.293"/><path fill="currentColor" d="M17.293 2.293C17 2.586 17 3.057 17 4v13c0 .943 0 1.414.293 1.707S18.057 19 19 19s1.414 0 1.707-.293S21 17.943 21 17V4c0-.943 0-1.414-.293-1.707S19.943 2 19 2s-1.414 0-1.707.293" opacity=".4"/><path fill="currentColor" d="M10 7c0-.943 0-1.414.293-1.707S11.057 5 12 5s1.414 0 1.707.293S14 6.057 14 7v10c0 .943 0 1.414-.293 1.707S12.943 19 12 19s-1.414 0-1.707-.293S10 17.943 10 17z" opacity=".7"/><path fill="currentColor" d="M3 21.25a.75.75 0 0 0 0 1.5h18a.75.75 0 0 0 0-1.5z"/></svg>
                                    </span>
                                    <div>İşlem</div>
                                </div>
                                <div class="flex-0">
                                    <div class="text-base rounded-full flex justify-center items-center transition-all duration-300 group-hover:text-primary-foreground text-muted-foreground">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20"><path fill="currentColor" fill-rule="evenodd" d="M8.22 5.22a.75.75 0 0 1 1.06 0l4.25 4.25a.75.75 0 0 1 0 1.06l-4.25 4.25a.75.75 0 0 1-1.06-1.06L11.94 10L8.22 6.28a.75.75 0 0 1 0-1.06" clip-rule="evenodd"/></svg>
                                    </div>
                                </div>
                            </div>
                            <div data-state="closed" data-slot="collapsible">
                                <div id="mobile-sec-trading" hidden data-slot="collapsible-content" class="CollapsibleContent">
                                    <a href="trade.php" class="block px-5 py-2.5 text-sm hover:bg-primary/10 rounded">Spot İşlem</a>
                                    <a href="futures.php" class="block px-5 py-2.5 text-sm hover:bg-primary/10 rounded">Vadeli İşlem</a>
                                    <a href="markets.php" class="block px-5 py-2.5 text-sm hover:bg-primary/10 rounded">Piyasalar</a>
                                    <a href="historical.php" class="block px-5 py-2.5 text-sm hover:bg-primary/10 rounded">Geçmiş Veriler</a>
                                </div>
                            </div>
                        </li>

                        <!-- Portfolio -->
                        <li>
                            <div class="flex text-foreground group font-medium text-sm capitalize px-[10px] py-3 rounded cursor-pointer transition-all duration-100 hover:bg-primary hover:text-primary-foreground" onclick="toggleMobileSection('portfolio')" aria-controls="mobile-sec-portfolio" aria-expanded="false">
                                <div class="flex-1 gap-3 flex items-start">
                                    <span class="inline-flex items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24"><path fill="currentColor" d="M4.892 9.614c0-.402.323-.728.722-.728H9.47c.4 0 .723.326.723.728a.726.726 0 0 1-.723.729H5.614a.726.726 0 0 1-.722-.729"/><path fill="currentColor" fill-rule="evenodd" d="M21.188 10.004q-.094-.005-.2-.004h-2.773C15.944 10 14 11.736 14 14s1.944 4 4.215 4h2.773q.106.001.2-.004c.923-.056 1.739-.757 1.808-1.737c.004-.064.004-.133.004-.197v-4.124c0-.064 0-.133-.004-.197c-.069-.98-.885-1.68-1.808-1.737m-3.217 5.063c.584 0 1.058-.478 1.058-1.067c0-.59-.474-1.067-1.058-1.067s-1.06.478-1.06 1.067c0 .59.475 1.067 1.06 1.067" clip-rule="evenodd"/><path fill="currentColor" d="M21.14 10.002c0-1.181-.044-2.448-.798-3.355a4 4 0 0 0-.233-.256c-.749-.748-1.698-1.08-2.87-1.238C16.099 5 14.644 5 12.806 5h-2.112C8.856 5 7.4 5 6.26 5.153c-1.172.158-2.121.49-2.87 1.238c-.748.749-1.08 1.698-1.238 2.87C2 10.401 2 11.856 2 13.694v.112c0 1.838 0 3.294.153 4.433c.158 1.172.49 2.121 1.238 2.87c.749.748 1.698 1.08 2.87 1.238c1.14.153 2.595.153 4.433.153h2.112c1.838 0 3.294 0 4.433-.153c1.172-.158 2.121-.49 2.87-1.238q.305-.308.526-.66c.45-.72.504-1.602.504-2.45l-.15.001h-2.774C15.944 18 14 16.264 14 14s1.944-4 4.215-4h2.773q.079 0 .151.002" opacity=".5"/><path fill="currentColor" d="M10.101 2.572L8 3.992l-1.733 1.16C7.405 5 8.859 5 10.694 5h2.112c1.838 0 3.294 0 4.433.153q.344.045.662.114L16 4l-2.113-1.428a3.42 3.42 0 0 0-3.786 0"/></svg>
                                    </span>
                                    <div>Portföy</div>
                                </div>
                                <div class="flex-0">
                                    <div class="text-base rounded-full flex justify-center items-center transition-all duration-300 group-hover:text-primary-foreground text-muted-foreground">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20"><path fill="currentColor" fill-rule="evenodd" d="M8.22 5.22a.75.75 0 0 1 1.06 0l4.25 4.25a.75.75 0 0 1 0 1.06l-4.25 4.25a.75.75 0 0 1-1.06-1.06L11.94 10L8.22 6.28a.75.75 0 0 1 0-1.06" clip-rule="evenodd"/></svg>
                                    </div>
                                </div>
                            </div>
                            <div data-state="closed" data-slot="collapsible">
                                <div id="mobile-sec-portfolio" hidden data-slot="collapsible-content" class="CollapsibleContent">
                                    <a href="portfolio.php" class="block px-5 py-2.5 text-sm hover:bg-primary/10 rounded">Portföy</a>
                                    <a href="wallet.php" class="block px-5 py-2.5 text-sm hover:bg-primary/10 rounded">Cüzdan</a>
                                    <a href="wallet-history.php" class="block px-5 py-2.5 text-sm hover:bg-primary/10 rounded">Geçmiş</a>
                                </div>
                            </div>
                        </li>

                        <!-- Investments -->
                        <li>
                            <div class="flex text-foreground group font-medium text-sm capitalize px-[10px] py-3 rounded cursor-pointer transition-all duration-100 hover:bg-primary hover:text-primary-foreground" onclick="toggleMobileSection('invest')" aria-controls="mobile-sec-invest" aria-expanded="false">
                                <div class="flex-1 gap-3 flex items-start">
                                    <span class="inline-flex items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"><path d="m22 7l-7.38 7.335c-.997.991-1.496 1.487-2.115 1.487s-1.117-.496-2.115-1.488l-.24-.238c-.997-.992-1.497-1.489-2.116-1.489s-1.118.497-2.115 1.49L2 18" opacity=".5"/><path d="M22 12.546V7h-5.582"/></g></svg>
                                    </span>
                                    <div>Yatırım</div>
                                </div>
                                <div class="flex-0">
                                    <div class="text-base rounded-full flex justify-center items-center transition-all duration-300 group-hover:text-primary-foreground text-muted-foreground">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20"><path fill="currentColor" fill-rule="evenodd" d="M8.22 5.22a.75.75 0 0 1 1.06 0l4.25 4.25a.75.75 0 0 1 0 1.06l-4.25 4.25a.75.75 0 0 1-1.06-1.06L11.94 10L8.22 6.28a.75.75 0 0 1 0-1.06" clip-rule="evenodd"/></svg>
                                    </div>
                                </div>
                            </div>
                            <div data-state="closed" data-slot="collapsible">
                                <div id="mobile-sec-invest" hidden data-slot="collapsible-content" class="CollapsibleContent">
                                    <a href="staking.php" class="block px-5 py-2.5 text-sm hover:bg-primary/10 rounded">Stake</a>
                                    <a href="lending.php" class="block px-5 py-2.5 text-sm hover:bg-primary/10 rounded">Borç Verme</a>
                                    <a href="yield.php" class="block px-5 py-2.5 text-sm hover:bg-primary/10 rounded">Yield Tarımı</a>
                                </div>
                            </div>
                        </li>

                        <!-- Marketplace -->
                        <li>
                            <div class="flex text-foreground group font-medium text-sm capitalize px-[10px] py-3 rounded cursor-pointer transition-all duration-100 hover:bg-primary hover:text-primary-foreground" onclick="toggleMobileSection('services')" aria-controls="mobile-sec-services" aria-expanded="false">
                                <div class="flex-1 gap-3 flex items-start">
                                    <span class="inline-flex items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24"><path fill="currentColor" d="M4.083 11.894c.439-2.34.658-3.511 1.491-4.203C6.408 7 7.598 7 9.98 7h4.04c2.383 0 3.573 0 4.407.691c.833.692 1.052 1.862 1.491 4.203l.75 4c.617 3.292.926 4.938.026 6.022S18.12 23 14.771 23H9.23c-3.349 0-5.024 0-5.923-1.084c-.9-1.084-.591-2.73.026-6.022z" opacity=".5"/><path fill="currentColor" d="M9.75 5.985a2.25 2.25 0 0 1 4.5 0v1c.566 0 1.062.002 1.5.015V5.985a3.75 3.75 0 1 0-7.5 0V7c.438-.013.934-.015 1.5-.015zm.128 9.765a2.251 2.251 0 0 0 4.245 0a.75.75 0 1 1 1.414.5a3.751 3.751 0 0 1-7.073 0a.75.75 0 0 1 1.414-.5"/></svg>
                                    </span>
                                    <div>Pazar</div>
                                </div>
                                <div class="flex-0">
                                    <div class="text-base rounded-full flex justify-center items-center transition-all duration-300 group-hover:text-primary-foreground text-muted-foreground">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20"><path fill="currentColor" fill-rule="evenodd" d="M8.22 5.22a.75.75 0 0 1 1.06 0l4.25 4.25a.75.75 0 0 1 0 1.06l-4.25 4.25a.75.75 0 0 1-1.06-1.06L11.94 10L8.22 6.28a.75.75 0 0 1 0-1.06" clip-rule="evenodd"/></svg>
                                    </div>
                                </div>
                            </div>
                            <div data-state="closed" data-slot="collapsible">
                                <div id="mobile-sec-services" hidden data-slot="collapsible-content" class="CollapsibleContent">
                                    <a href="markets.php" class="block px-5 py-2.5 text-sm hover:bg-primary/10 rounded">Piyasalar</a>
                                    <a href="historical.php" class="block px-5 py-2.5 text-sm hover:bg-primary/10 rounded">Piyasa Analizi</a>
                                </div>
                            </div>
                        </li>

                        <!-- Services -->
                        <li>
                            <div class="flex text-foreground group font-medium text-sm capitalize px-[10px] py-3 rounded cursor-pointer transition-all duration-100 hover:bg-primary hover:text-primary-foreground" onclick="toggleMobileSection('help')" aria-controls="mobile-sec-help" aria-expanded="false">
                                <div class="flex-1 gap-3 flex items-start">
                                    <span class="inline-flex items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24"><path fill="currentColor" fill-rule="evenodd" d="M14.279 2.152C13.909 2 13.439 2 12.5 2s-1.408 0-1.779.152a2 2 0 0 0-1.09 1.083c-.094.223-.13.484-.145.863a1.62 1.62 0 0 1-.796 1.353a1.64 1.64 0 0 1-1.579.008c-.338-.178-.583-.276-.825-.308a2.03 2.03 0 0 0-1.49.396c-.318.242-.553.646-1.022 1.453c-.47.807-.704 1.21-.757 1.605c-.07.526.074 1.058.4 1.479c.148.192.357.353.68.555c.477.297.783.803.783 1.361s-.306 1.064-.782 1.36c-.324.203-.533.364-.682.556a2 2 0 0 0-.399 1.479c.053.394.287.798.757 1.605s.704 1.21 1.022 1.453c.424.323.96.465 1.49.396c.242-.032.487-.13.825-.308a1.64 1.64 0 0 1 1.58.008c.486.28.774.795.795 1.353c.015.38.051.64.145.863c.204.49.596.88 1.09 1.083c.37.152.84.152 1.779.152s1.409 0 1.779-.152a2 2 0 0 0 1.09-1.083c.094-.223.13-.483.145-.863c.02-.558.309-1.074.796-1.353a1.64 1.64 0 0 1 1.579-.008c.338.178.583.276.825.308c.53.07 1.066-.073 1.49-.396c.318-.242.553-.646 1.022-1.453c.47-.807.704-1.21.757-1.605a2 2 0 0 0-.4-1.479c-.148-.192-.357-.353-.68-.555c-.477-.297-.783-.803-.783-1.361s.306-1.064.782-1.36c.324-.203.533-.364.682-.556a2 2 0 0 0 .399-1.479c-.053-.394-.287-.798-.757-1.605s-.704-1.21-1.022-1.453a2.03 2.03 0 0 0-1.49-.396c-.242.032-.487.13-.825.308a1.64 1.64 0 0 1-1.58-.008a1.62 1.62 0 0 1-.795-1.353c-.015-.38-.051-.64-.145-.863a2 2 0 0 0-1.09-1.083" opacity=".5"/><path fill="currentColor" d="M15.523 12c0 1.657-1.354 3-3.023 3s-3.023-1.343-3.023-3S10.83 9 12.5 9s3.023 1.343 3.023 3"/></svg>
                                    </span>
                                    <div>Hizmetler</div>
                                </div>
                                <div class="flex-0">
                                    <div class="text-base rounded-full flex justify-center items-center transition-all duration-300 group-hover:text-primary-foreground text-muted-foreground">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20"><path fill="currentColor" fill-rule="evenodd" d="M8.22 5.22a.75.75 0 0 1 1.06 0l4.25 4.25a.75.75 0 0 1 0 1.06l-4.25 4.25a.75.75 0 0 1-1.06-1.06L11.94 10L8.22 6.28a.75.75 0 0 1 0-1.06" clip-rule="evenodd"/></svg>
                                    </div>
                                </div>
                            </div>
                            <div data-state="closed" data-slot="collapsible">
                                <div id="mobile-sec-help" hidden data-slot="collapsible-content" class="CollapsibleContent">
                                    <a href="index.php" class="block px-5 py-2.5 text-sm hover:bg-primary/10 rounded">API Dokümantasyonu</a>
                                    <a href="index.php" class="block px-5 py-2.5 text-sm hover:bg-primary/10 rounded">Destek</a>
                                    <a href="index.php" class="block px-5 py-2.5 text-sm hover:bg-primary/10 rounded">Yardım Merkezi</a>
                                </div>
                            </div>
                        </li>

                        <!-- Insights -->
                        <li>
                            <a href="index.php">
                                <div class="flex gap-3 group text-foreground font-medium text-sm capitalize px-[10px] py-3 rounded cursor-pointer hover:bg-primary hover:text-primary-foreground">
                                    <span class="grow-0">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 28 28"><path fill="currentColor" d="M6.75 3A3.75 3.75 0 0 0 3 6.75v14.5A3.75 3.75 0 0 0 6.75 25h14.5A3.75 3.75 0 0 0 25 21.25V6.75A3.75 3.75 0 0 0 21.25 3zM4.5 6.75A2.25 2.25 0 0 1 6.75 4.5h14.5a2.25 2.25 0 0 1 2.25 2.25v14.5a2.25 2.25 0 0 1-2.25 2.25H6.75a2.25 2.25 0 0 1-2.25-2.25zM6 9a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2zm2-.5a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 .5.5h12a.5.5 0 0 0 .5-.5V9a.5.5 0 0 0-.5-.5zm-2 7.25a.75.75 0 0 1 .75-.75h5.5a.75.75 0 0 1 0 1.5h-5.5a.75.75 0 0 1-.75-.75m.75 3a.75.75 0 0 0 0 1.5h5.5a.75.75 0 0 0 0-1.5zm8.75-2.5c0-.966.784-1.75 1.75-1.75h3c.966 0 1.75.784 1.75 1.75v3A1.75 1.75 0 0 1 20.25 21h-3a1.75 1.75 0 0 1-1.75-1.75zm1.75-.25a.25.25 0 0 0-.25.25v3c0 .138.112.25.25.25h3a.25.25 0 0 0 .25-.25v-3a.25.25 0 0 0-.25-.25z"/></svg>
                                    </span>
                                    <div class="text-box grow">İçgörüler</div>
                                </div>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Language -->
            <div class="mt-4 px-2">
                <button class="w-full flex items-center gap-2 p-2 rounded-md transition-colors text-zinc-600 hover:text-zinc-900 hover:bg-zinc-100">
                    <img src="assets/uploads/flags/tr.png" alt="TR" class="h-5 w-5 rounded-full"/>
                    <span class="text-sm">Türkçe</span>
                </button>
            </div>
        </nav>
    </div>
</aside>

<!-- Login Modal -->
<div id="loginModal" class="fixed inset-0 z-50 hidden flex items-center justify-center p-4">
    <!-- Modal Overlay -->
    <div class="fixed inset-0 bg-black/50 backdrop-blur-sm" onclick="closeLoginModal()"></div>
    
    <!-- Login Modal Content -->
    <div role="dialog" id="login-modal-content" aria-describedby="login-description" aria-labelledby="login-title" 
         data-state="open" data-slot="dialog-content" 
         class="bg-background data-[state=open]:animate-in data-[state=closed]:animate-out data-[state=closed]:fade-out-0 data-[state=open]:fade-in-0 data-[state=closed]:zoom-out-95 data-[state=open]:zoom-in-95 relative z-[10000] grid gap-4 border duration-200 p-0 border-none shadow-2xl rounded-xl w-[95vw] sm:w-full max-w-xl max-h-[90vh] overflow-hidden bg-gradient-to-b from-background to-background/95 backdrop-blur-sm mx-auto" 
         tabindex="-1" style="pointer-events: auto;">
        
        <h2 id="login-title" data-slot="dialog-title" class="text-lg leading-none font-semibold">
            <span class="sr-only">Kimlik Doğrulama</span>
        </h2>
        
        <p id="login-description" data-slot="dialog-description" class="text-muted-foreground text-sm">
            <span class="sr-only">Güvenli bir şekilde giriş yapın veya hesap oluşturun.</span>
        </p>
        
        <!-- Background Effects -->
        <div class="absolute inset-0 overflow-hidden pointer-events-none">
            <div class="absolute -top-24 -left-24 w-64 h-64 bg-primary/10 rounded-full blur-3xl"></div>
            <div class="absolute -bottom-24 -right-24 w-64 h-64 bg-primary/10 rounded-full blur-3xl"></div>
        </div>
        
        <!-- Close Button -->
        <button type="button" onclick="closeLoginModal()" 
                class="hidden absolute right-4 top-4 rounded-sm opacity-70 ring-offset-background transition-opacity hover:opacity-100 focus:outline-none focus:ring-2 focus:ring-ring focus:ring-offset-2 disabled:pointer-events-none data-[state=open]:bg-accent data-[state=open]:text-muted-foreground">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x h-4 w-4">
                <path d="M18 6 6 18"></path>
                <path d="m6 6 12 12"></path>
            </svg>
            <span class="sr-only">Close</span>
        </button>
        
        <!-- Modal Content -->
        <div class="max-h-[90vh] pb-8 overflow-y-auto scrollbar-hide auth-modal-content opacity-100">
            <div class="p-8">
                <div class="space-y-6">
                    <!-- Header -->
                    <div class="space-y-2 text-center">
                        <h2 class="text-3xl font-bold">Tekrar hoş geldiniz</h2>
                        <p class="text-muted-foreground">Hesabınızda oturum açmak için kimlik bilgilerinizi girin</p>
                    </div>
                    
                    <!-- Login Form -->
                    <div id="login-error-message" class="hidden bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-md text-sm flex items-center space-x-2 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-alert-circle flex-shrink-0">
                            <circle cx="12" cy="12" r="10"></circle>
                            <line x1="12" x2="12" y1="8" y2="12"></line>
                            <line x1="12" x2="12.01" y1="16" y2="16"></line>
                        </svg>
                        <span id="login-error-text"></span>
                    </div>
                    <form class="space-y-4" id="login-form" onsubmit="handleLoginSubmit(event); return false;">
                        <!-- Email Field -->
                        <div class="space-y-2">
                            <div class="relative transition-all duration-200">
                                <div class="flex-1 w-full flex flex-col">
                                    <div class="border-input placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground h-9 w-full min-w-0 rounded-md border bg-transparent px-3 text-base outline-hidden disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm aria-invalid:ring-destructive/20 aria-invalid:border-destructive flex items-center focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] shadow-sm pl-10 py-6 transition-all">
                                        <input data-slot="input" class="flex-1 bg-transparent border-none p-0 m-0 focus:outline-none focus:ring-0" 
                                               placeholder="Email" required="" type="email" name="email" value="">
                                    </div>
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-mail absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 transition-colors text-muted-foreground">
                                    <rect width="20" height="16" x="2" y="4" rx="2"></rect>
                                    <path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"></path>
                                </svg>
                            </div>
                        </div>
                        
                        <!-- Password Field -->
                        <div class="space-y-2">
                            <div class="relative transition-all duration-200">
                                <div class="flex-1 w-full flex flex-col">
                                    <div class="border-input placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground h-9 w-full min-w-0 rounded-md border bg-transparent px-3 text-base outline-hidden disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm aria-invalid:ring-destructive/20 aria-invalid:border-destructive flex items-center focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] shadow-sm pl-10 pr-10 py-6 transition-all">
                                        <input data-slot="input" class="flex-1 bg-transparent border-none p-0 m-0 focus:outline-none focus:ring-0" 
                                               placeholder="Password" required="" type="password" name="password" value="" id="password">
                                    </div>
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-lock absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 transition-colors text-muted-foreground">
                                    <rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect>
                                    <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                                </svg>
                                <button type="button" onclick="togglePassword()" class="absolute right-3 top-1/2 -translate-y-1/2 h-5 w-5 text-muted-foreground hover:text-primary transition-colors" tabindex="-1">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-eye" id="eye-icon">
                                        <path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path>
                                        <circle cx="12" cy="12" r="3"></circle>
                                    </svg>
                                </button>
                            </div>
                        </div>
                        
                        <!-- Remember Me & Forgot Password -->
                        <div class="flex items-center justify-between">
                            <div class="flex items-center space-x-2">
                                <button type="button" role="checkbox" aria-checked="false" data-state="unchecked" value="on" data-slot="checkbox" class="size-4 rounded-md peer border-input data-[state=checked]:bg-primary data-[state=checked]:text-primary-foreground data-[state=checked]:border-primary focus-visible:border-ring focus-visible:ring-ring/50 aria-invalid:ring-destructive/20 aria-invalid:border-destructive shrink-0 border shadow-2xs transition-shadow outline-hidden focus-visible:ring-[3px] disabled:cursor-not-allowed disabled:opacity-50" id="remember-me"></button>
                                <input aria-hidden="true" tabindex="-1" type="checkbox" value="on" style="position: absolute; pointer-events: none; opacity: 0; margin: 0px; transform: translateX(-100%); width: 16px; height: 16px;">
                                <label for="remember-me" class="text-sm text-muted-foreground cursor-pointer">Beni hatırla</label>
                            </div>
                            <button data-slot="button" class="inline-flex cursor-pointer items-center justify-center gap-2 whitespace-nowrap rounded-md font-medium transition-[color,box-shadow] disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-hidden focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 aria-invalid:border-destructive text-primary underline-offset-4 hover:underline p-0 h-auto text-sm" type="button">Şifrenizi mi unuttunuz?</button>
                        </div>
                        
                        <!-- Submit Button -->
                        <button data-slot="button" class="inline-flex cursor-pointer items-center justify-center gap-2 whitespace-nowrap rounded-md font-medium transition-[color,box-shadow] disabled:pointer-events-none [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-hidden focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 aria-invalid:border-destructive bg-primary text-primary-foreground shadow-2xs hover:bg-primary/90 h-10 px-4 w-full py-6 text-base disabled:opacity-50 disabled:cursor-not-allowed" type="submit">Sign in</button>
                    </form>
                    
                    <!-- Wallet Login -->
                    <div class="space-y-4">
                        <button data-slot="button" class="inline-flex cursor-pointer items-center justify-center gap-2 whitespace-nowrap rounded-md font-medium transition-[color,box-shadow] disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-hidden focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 aria-invalid:border-destructive border border-input bg-background shadow-2xs hover:bg-accent hover:text-accent-foreground h-10 px-4 w-full py-6 text-base">
                            <svg class="mr-2 h-5 w-5" aria-hidden="true" focusable="false" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                <path fill="currentColor" d="M461.2 128H80c-8.84 0-16-7.16-16-16s7.16-16 16-16h384c8.84 0 16-7.16 16-16 0-26.51-21.49-48-48-48H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h397.2c28.02 0 50.8-21.53 50.8-48V176c0-26.47-22.78-48-50.8-48zM416 336c-17.67 0-32-14.33-32-32s14.33-32 32-32 32 14.33 32 32-14.33 32-32 32z"></path>
                            </svg>
                            Cüzdan ile devam et
                        </button>
                    </div>
                    
                    <!-- Trust Indicators -->
                    <div class="text-center text-xs text-muted-foreground">
                        <p>Dünya çapında 10.000+ kullanıcı tarafından güvenilen</p>
                        <div class="flex justify-center mt-2 space-x-1">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                        </div>
                    </div>
                    
                    <!-- Sign Up Link -->
                    <div class="text-center">
                        <p class="text-sm text-muted-foreground">Hesabınız yok mu? 
                            <button onclick="closeLoginModal(); openRegisterModal();" class="inline-flex cursor-pointer items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-[color,box-shadow] disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-hidden focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 aria-invalid:border-destructive text-primary underline-offset-4 hover:underline p-0 h-auto">Kaydol</button>
                        </p>
                    </div>
                </div>
            </div>
            
            <!-- Security Features -->
            <div class="px-8 pb-8 pt-2">
                <div class="flex flex-col items-center justify-center space-y-3 text-center">
                    <div class="flex items-center justify-center space-x-2 text-xs text-muted-foreground">
                        <div class="flex items-center justify-center w-8 h-8 rounded-full bg-primary/10">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-lock h-4 w-4 text-primary">
                                <rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect>
                                <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                            </svg>
                        </div>
                        <span>Güvenli kimlik doğrulama</span>
                        <div class="w-px h-4 bg-border"></div>
                        <div class="flex items-center justify-center w-8 h-8 rounded-full bg-primary/10">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-shield h-4 w-4 text-primary">
                                <path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"></path>
                            </svg>
                        </div>
                        <span>Veri koruma</span>
                        <div class="w-px h-4 bg-border"></div>
                        <div class="flex items-center justify-center w-8 h-8 rounded-full bg-primary/10">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-4 w-4 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                        </div>
                        <span>Doğrulanmış güvenlik</span>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Close Button -->
        <button type="button" onclick="closeLoginModal()" 
                class="ring-offset-background focus:ring-ring data-[state=open]:bg-accent data-[state=open]:text-muted-foreground absolute top-4 right-4 rounded-xs opacity-70 transition-opacity hover:opacity-100 focus:ring-2 focus:ring-offset-2 focus:outline-hidden disabled:pointer-events-none [&_svg]:pointer-events-none [&_svg]:shrink-0 [&_svg:not([class*='size-'])]:size-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                <path d="M18 6 6 18"></path>
                <path d="m6 6 12 12"></path>
            </svg>
            <span class="sr-only">Close</span>
        </button>
    </div>
</div>

<!-- Register Modal -->
<div id="registerModal" class="fixed inset-0 z-50 hidden flex items-center justify-center p-4">
    <!-- Modal Overlay -->
    <div class="fixed inset-0 bg-black/50 backdrop-blur-sm" onclick="closeRegisterModal()"></div>
    
    <!-- Register Modal Content -->
    <div role="dialog" id="register-modal-content" aria-describedby="register-description" aria-labelledby="register-title" 
         data-state="open" data-slot="dialog-content" 
         class="bg-background data-[state=open]:animate-in data-[state=closed]:animate-out data-[state=closed]:fade-out-0 data-[state=open]:fade-in-0 data-[state=closed]:zoom-out-95 data-[state=open]:zoom-in-95 relative z-50 grid gap-4 border duration-200 p-0 border-none shadow-2xl rounded-xl w-[95vw] sm:w-full max-w-xl max-h-[90vh] overflow-hidden bg-gradient-to-b from-background to-background/95 backdrop-blur-sm mx-auto" 
         tabindex="-1" style="pointer-events: auto;">
        
        <h2 id="register-title" data-slot="dialog-title" class="text-lg leading-none font-semibold">
            <span class="sr-only">Authentication</span>
        </h2>
        
        <p id="register-description" data-slot="dialog-description" class="text-muted-foreground text-sm">
            <span class="sr-only">Sign in or create an account securely.</span>
        </p>
        
        <!-- Background Effects -->
        <div class="absolute inset-0 overflow-hidden pointer-events-none">
            <div class="absolute -top-24 -left-24 w-64 h-64 bg-primary/10 rounded-full blur-3xl"></div>
            <div class="absolute -bottom-24 -right-24 w-64 h-64 bg-primary/10 rounded-full blur-3xl"></div>
        </div>
        
        <!-- Modal Content -->
        <div class="max-h-[90vh] pb-8 overflow-y-auto scrollbar-hide auth-modal-content opacity-100">
            <div class="p-8">
                <div class="space-y-6">
                    <!-- Header -->
                    <div class="space-y-2 text-center">
                        <h2 class="text-3xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-primary to-primary/70">Hesap oluştur</h2>
                        <p class="text-muted-foreground">Hesabınızı oluşturmak için bilgilerinizi girin</p>
                    </div>
                    
                    <!-- Register Form -->
                    <form id="register-form-header" class="space-y-5" action="auth/register.php" method="POST">
                        <!-- Name Fields -->
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                            <div class="relative transition-all duration-300 form-field-animate rounded-lg ring-1 ring-input">
                                <div class="flex-1 w-full flex flex-col">
                                    <div class="border-input placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground h-9 w-full min-w-0 rounded-md px-3 transition-[color,box-shadow] outline-hidden disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm aria-invalid:ring-destructive/20 aria-invalid:border-destructive flex items-center focus-visible:border-ring focus-visible:ring-ring/50 shadow-sm border-0 pl-10 py-6 bg-transparent focus-visible:ring-0 focus-visible:ring-offset-0 text-base">
                                        <input data-slot="input" class="flex-1 bg-transparent border-none p-0 m-0 focus:outline-none focus:ring-0" 
                                               placeholder="First Name" required="" type="text" name="first_name" value="">
                                    </div>
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-user absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 transition-colors text-muted-foreground">
                                    <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                            </div>
                            <div class="relative transition-all duration-300 form-field-animate rounded-lg ring-1 ring-input">
                                <div class="flex-1 w-full flex flex-col">
                                    <div class="border-input placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground h-9 w-full min-w-0 rounded-md px-3 transition-[color,box-shadow] outline-hidden disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm aria-invalid:ring-destructive/20 aria-invalid:border-destructive flex items-center focus-visible:border-ring focus-visible:ring-ring/50 shadow-sm border-0 pl-10 py-6 bg-transparent focus-visible:ring-0 focus-visible:ring-offset-0 text-base">
                                        <input data-slot="input" class="flex-1 bg-transparent border-none p-0 m-0 focus:outline-none focus:ring-0" 
                                               placeholder="Last Name" required="" type="text" name="last_name" value="">
                                    </div>
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-user absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 transition-colors text-muted-foreground">
                                    <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                            </div>
                        </div>
                        
                        <!-- Email Field -->
                        <div class="space-y-2">
                            <div class="relative transition-all duration-300 form-field-animate rounded-lg ring-1 ring-input">
                                <div class="flex-1 w-full flex flex-col">
                                    <div class="border-input placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground h-9 w-full min-w-0 rounded-md px-3 transition-[color,box-shadow] outline-hidden disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm aria-invalid:ring-destructive/20 aria-invalid:border-destructive flex items-center focus-visible:border-ring focus-visible:ring-ring/50 shadow-sm border-0 pl-10 py-6 bg-transparent focus-visible:ring-0 focus-visible:ring-offset-0 text-base">
                                        <input data-slot="input" class="flex-1 bg-transparent border-none p-0 m-0 focus:outline-none focus:ring-0" 
                                               placeholder="Email" required="" type="email" name="email" value="">
                                    </div>
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-mail absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 transition-colors text-muted-foreground">
                                    <rect width="20" height="16" x="2" y="4" rx="2"></rect>
                                    <path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"></path>
                                </svg>
                            </div>
                        </div>
                        
                        <!-- Password Field -->
                        <div class="space-y-2">
                            <div class="relative transition-all duration-300 form-field-animate rounded-lg ring-1 ring-input">
                                <div class="flex-1 w-full flex flex-col">
                                    <div class="border-input placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground h-9 w-full min-w-0 rounded-md px-3 text-base transition-[color,box-shadow] outline-hidden disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm aria-invalid:ring-destructive/20 aria-invalid:border-destructive flex items-center focus-visible:border-ring focus-visible:ring-ring/50 shadow-sm border-0 pl-10 pr-10 py-6 bg-transparent focus-visible:ring-0 focus-visible:ring-offset-0">
                                        <input data-slot="input" class="flex-1 bg-transparent border-none p-0 m-0 focus:outline-none focus:ring-0" 
                                               placeholder="Password" required="" type="password" name="password" value="" id="register-password">
                                    </div>
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-lock absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 transition-colors text-muted-foreground">
                                    <rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect>
                                    <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                                </svg>
                                <button type="button" onclick="toggleRegisterPassword()" class="absolute right-3 top-1/2 -translate-y-1/2 h-5 w-5 text-muted-foreground hover:text-primary transition-colors" tabindex="-1">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-eye" id="register-eye-icon">
                                        <path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path>
                                        <circle cx="12" cy="12" r="3"></circle>
                                    </svg>
                                </button>
                            </div>
                            <div class="space-y-2 mt-2">
                                <div class="text-xs text-muted-foreground bg-muted/50 p-3 rounded-lg">
                                    <div class="flex items-center mb-1">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-info h-3 w-3 mr-1">
                                            <circle cx="12" cy="12" r="10"></circle>
                                            <path d="M12 16v-4"></path>
                                            <path d="M12 8h.01"></path>
                                        </svg>
                                        <span class="font-medium">Password must contain:</span>
                                    </div>
                                    <ul class="list-disc list-inside space-y-0.5 ml-4 text-xs">
                                        <li>At least 8 characters</li>
                                        <li>One uppercase letter</li>
                                        <li>One lowercase letter</li>
                                        <li>One number</li>
                                        <li>One special character</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Confirm Password Field -->
                        <div class="space-y-2">
                            <div class="relative transition-all duration-300 form-field-animate rounded-lg ring-1 ring-input">
                                <div class="flex-1 w-full flex flex-col">
                                    <div class="border-input placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground h-9 w-full min-w-0 rounded-md px-3 text-base transition-[color,box-shadow] outline-hidden disabled:pointer-events-none disabled:cursor-not-allowed disabled:opacity-50 md:text-sm aria-invalid:ring-destructive/20 aria-invalid:border-destructive flex items-center focus-visible:border-ring focus-visible:ring-ring/50 shadow-sm border-0 pl-10 pr-10 py-6 bg-transparent focus-visible:ring-0 focus-visible:ring-offset-0">
                                        <input data-slot="input" class="flex-1 bg-transparent border-none p-0 m-0 focus:outline-none focus:ring-0" 
                                               placeholder="Confirm Password" required="" type="password" name="confirm_password" value="" id="register-confirm-password">
                                    </div>
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-lock absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 transition-colors text-muted-foreground">
                                    <rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect>
                                    <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                                </svg>
                                <button type="button" onclick="toggleRegisterConfirmPassword()" class="absolute right-3 top-1/2 -translate-y-1/2 h-5 w-5 text-muted-foreground hover:text-primary transition-colors" tabindex="-1">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-eye" id="register-confirm-eye-icon">
                                        <path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path>
                                        <circle cx="12" cy="12" r="3"></circle>
                                    </svg>
                                </button>
                            </div>
                        </div>
                        
                        <!-- Submit Button -->
                        <button data-slot="button" class="inline-flex cursor-pointer items-center justify-center gap-2 whitespace-nowrap rounded-md font-medium disabled:pointer-events-none [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-hidden focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 aria-invalid:border-destructive bg-primary text-primary-foreground shadow-2xs hover:bg-primary/90 h-10 px-4 w-full py-6 text-base relative overflow-hidden btn-glow transition-all duration-300 bg-gradient-to-r from-primary to-primary/90 hover:from-primary/90 hover:to-primary disabled:opacity-50 disabled:cursor-not-allowed" type="submit">
                            <span class="flex items-center justify-center">
                                Hesap oluştur
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-right ml-2 h-4 w-4">
                                    <path d="M5 12h14"></path>
                                    <path d="m12 5 7 7-7 7"></path>
                                </svg>
                            </span>
                        </button>
                    </form>
                    
                    <!-- Trust Indicators -->
                    <div class="text-center text-xs text-muted-foreground">
                        <p>Dünya çapında 10.000+ kullanıcıya katılın</p>
                        <div class="flex justify-center mt-2 space-x-1">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-3 w-3 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                        </div>
                    </div>
                    
                    <!-- Sign In Link -->
                    <div class="text-center">
                        <p class="text-sm text-muted-foreground">Zaten bir hesabınız var mı? 
                            <button onclick="closeRegisterModal(); openLoginModal();" class="inline-flex cursor-pointer items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm transition-[color,box-shadow] disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-hidden focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 aria-invalid:border-destructive text-primary underline-offset-4 hover:underline p-0 h-auto font-semibold">Oturum Aç</button>
                        </p>
                    </div>
                </div>
            </div>
            
            <!-- Security Features -->
            <div class="px-8 pb-8 pt-2">
                <div class="flex flex-col items-center justify-center space-y-3 text-center">
                    <div class="flex items-center justify-center space-x-2 text-xs text-muted-foreground">
                        <div class="flex items-center justify-center w-8 h-8 rounded-full bg-primary/10">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-lock h-4 w-4 text-primary">
                                <rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect>
                                <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                            </svg>
                        </div>
                        <span>Güvenli kimlik doğrulama</span>
                        <div class="w-px h-4 bg-border"></div>
                        <div class="flex items-center justify-center w-8 h-8 rounded-full bg-primary/10">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-shield h-4 w-4 text-primary">
                                <path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"></path>
                            </svg>
                        </div>
                        <span>Veri koruma</span>
                        <div class="w-px h-4 bg-border"></div>
                        <div class="flex items-center justify-center w-8 h-8 rounded-full bg-primary/10">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check h-4 w-4 text-primary">
                                <circle cx="12" cy="12" r="10"></circle>
                                <path d="m9 12 2 2 4-4"></path>
                            </svg>
                        </div>
                        <span>Doğrulanmış güvenlik</span>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Close Button -->
        <button type="button" onclick="closeRegisterModal()" 
                class="ring-offset-background focus:ring-ring data-[state=open]:bg-accent data-[state=open]:text-muted-foreground absolute top-4 right-4 rounded-xs opacity-70 transition-opacity hover:opacity-100 focus:ring-2 focus:ring-offset-2 focus:outline-hidden disabled:pointer-events-none [&_svg]:pointer-events-none [&_svg]:shrink-0 [&_svg:not([class*='size-'])]:size-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                <path d="M18 6 6 18"></path>
                <path d="m6 6 12 12"></path>
            </svg>
            <span class="sr-only">Close</span>
        </button>
    </div>
</div>

<script>
// Login Modal Functions
function openLoginModal() {
    document.getElementById('loginModal').classList.remove('hidden');
    document.body.style.overflow = 'hidden'; // Prevent background scrolling
    // Hata mesajını temizle
    hideLoginError();
}

function closeLoginModal() {
    document.getElementById('loginModal').classList.add('hidden');
    document.body.style.overflow = 'auto'; // Restore scrolling
    // Hata mesajını temizle
    hideLoginError();
}

// Login hata mesajını göster
function showLoginError(message) {
    const errorDiv = document.getElementById('login-error-message');
    const errorText = document.getElementById('login-error-text');
    if (errorDiv && errorText) {
        errorText.textContent = message;
        errorDiv.classList.remove('hidden');
    }
}

// Login hata mesajını gizle
function hideLoginError() {
    const errorDiv = document.getElementById('login-error-message');
    if (errorDiv) {
        errorDiv.classList.add('hidden');
    }
}

// Login form submit handler
function handleLoginSubmit(event) {
    event.preventDefault();
    hideLoginError();
    
    const form = document.getElementById('login-form');
    const formData = new FormData(form);
    
    // Submit butonunu devre dışı bırak
    const submitBtn = form.querySelector('button[type="submit"]');
    const originalText = submitBtn.textContent;
    submitBtn.disabled = true;
    submitBtn.textContent = 'Giriş yapılıyor...';
    
    fetch('auth/login.php', {
        method: 'POST',
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Başarılı giriş - sayfayı yenile veya yönlendir
            if (data.redirect) {
                window.location.href = data.redirect;
            } else {
                window.location.reload();
            }
        } else {
            // Hata mesajını göster
            let errorMessage = 'Bir hata oluştu.';
            
            switch(data.error) {
                case 'invalid_credentials':
                    errorMessage = 'E-posta veya şifre hatalı. Lütfen tekrar deneyin.';
                    break;
                case 'email_required':
                    errorMessage = 'E-posta adresi gereklidir.';
                    break;
                case 'password_required':
                    errorMessage = 'Şifre gereklidir.';
                    break;
                case 'account_inactive':
                    errorMessage = 'Hesabınız aktif değil. Lütfen destek ekibi ile iletişime geçin.';
                    break;
                case 'database_error':
                    errorMessage = 'Bir hata oluştu. Lütfen tekrar deneyin.';
                    break;
            }
            showLoginError(errorMessage);
            submitBtn.disabled = false;
            submitBtn.textContent = originalText;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showLoginError('Bir hata oluştu. Lütfen tekrar deneyin.');
        submitBtn.disabled = false;
        submitBtn.textContent = originalText;
    });
}

// Password toggle functionality
function togglePassword() {
    const passwordInput = document.getElementById('password');
    const eyeIcon = document.getElementById('eye-icon');
    
    if (passwordInput.type === 'password') {
        passwordInput.type = 'text';
        eyeIcon.innerHTML = '<path d="M9.88 9.88a3 3 0 1 0 4.24 4.24"></path><path d="M10.73 5.08A10.43 10.43 0 0 1 12 5c7 0 10 7 10 7a13.16 13.16 0 0 1-1.67 2.68"></path><path d="M6.61 6.61A13.526 13.526 0 0 0 2 12s3 7 10 7a9.74 9.74 0 0 0 5.39-1.61"></path><line x1="2" x2="22" y1="2" y2="22"></line>';
    } else {
        passwordInput.type = 'password';
        eyeIcon.innerHTML = '<path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path><circle cx="12" cy="12" r="3"></circle>';
    }
}

// Remember me checkbox functionality
document.addEventListener('DOMContentLoaded', function() {
    const rememberCheckbox = document.getElementById('remember-me');
    if (rememberCheckbox) {
        const hiddenCheckbox = rememberCheckbox.nextElementSibling;
        
        rememberCheckbox.addEventListener('click', function() {
            const isChecked = rememberCheckbox.getAttribute('data-state') === 'checked';
            if (isChecked) {
                rememberCheckbox.setAttribute('data-state', 'unchecked');
                rememberCheckbox.setAttribute('aria-checked', 'false');
                hiddenCheckbox.checked = false;
            } else {
                rememberCheckbox.setAttribute('data-state', 'checked');
                rememberCheckbox.setAttribute('aria-checked', 'true');
                hiddenCheckbox.checked = true;
            }
        });
    }
    
    // URL'de error parametresi varsa login modal'ını aç
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.has('error')) {
        openLoginModal();
        const error = urlParams.get('error');
        let errorMessage = 'Bir hata oluştu.';
        
        switch(error) {
            case 'invalid_credentials':
                errorMessage = 'E-posta veya şifre hatalı. Lütfen tekrar deneyin.';
                break;
            case 'email_required':
                errorMessage = 'E-posta adresi gereklidir.';
                break;
            case 'password_required':
                errorMessage = 'Şifre gereklidir.';
                break;
            case 'account_inactive':
                errorMessage = 'Hesabınız aktif değil. Lütfen destek ekibi ile iletişime geçin.';
                break;
            case 'database_error':
                errorMessage = 'Bir hata oluştu. Lütfen tekrar deneyin.';
                break;
        }
        showLoginError(errorMessage);
        
        // URL'den error parametresini temizle
        const newUrl = window.location.pathname + (window.location.search.replace(/[?&]error=[^&]*/, '').replace(/^&/, '?'));
        window.history.replaceState({}, '', newUrl);
    }
});

// Register Modal Functions
function openRegisterModal() {
    document.getElementById('registerModal').classList.remove('hidden');
    document.body.style.overflow = 'hidden'; // Prevent background scrolling
}

function closeRegisterModal() {
    document.getElementById('registerModal').classList.add('hidden');
    document.body.style.overflow = 'auto'; // Restore scrolling
}

// Register password toggle functionality
function toggleRegisterPassword() {
    const passwordInput = document.getElementById('register-password');
    const eyeIcon = document.getElementById('register-eye-icon');
    
    if (passwordInput.type === 'password') {
        passwordInput.type = 'text';
        eyeIcon.innerHTML = '<path d="M9.88 9.88a3 3 0 1 0 4.24 4.24"></path><path d="M10.73 5.08A10.43 10.43 0 0 1 12 5c7 0 10 7 10 7a13.16 13.16 0 0 1-1.67 2.68"></path><path d="M6.61 6.61A13.526 13.526 0 0 0 2 12s3 7 10 7a9.74 9.74 0 0 0 5.39-1.61"></path><line x1="2" x2="22" y1="2" y2="22"></line>';
    } else {
        passwordInput.type = 'password';
        eyeIcon.innerHTML = '<path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path><circle cx="12" cy="12" r="3"></circle>';
    }
}

// Register confirm password toggle functionality
function toggleRegisterConfirmPassword() {
    const passwordInput = document.getElementById('register-confirm-password');
    const eyeIcon = document.getElementById('register-confirm-eye-icon');
    
    if (passwordInput.type === 'password') {
        passwordInput.type = 'text';
        eyeIcon.innerHTML = '<path d="M9.88 9.88a3 3 0 1 0 4.24 4.24"></path><path d="M10.73 5.08A10.43 10.43 0 0 1 12 5c7 0 10 7 10 7a13.16 13.16 0 0 1-1.67 2.68"></path><path d="M6.61 6.61A13.526 13.526 0 0 0 2 12s3 7 10 7a9.74 9.74 0 0 0 5.39-1.61"></path><line x1="2" x2="22" y1="2" y2="22"></line>';
    } else {
        passwordInput.type = 'password';
        eyeIcon.innerHTML = '<path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path><circle cx="12" cy="12" r="3"></circle>';
    }
}

// Close modal on escape key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeLoginModal();
        closeRegisterModal();
        closeProfileDropdown();
        closeMobileMenu();
    }
});

// Profile Dropdown Functions
function toggleProfileDropdown() {
    const dropdown = document.getElementById('profile-dropdown');
    dropdown.classList.toggle('hidden');
}

function closeProfileDropdown() {
    const dropdown = document.getElementById('profile-dropdown');
    dropdown.classList.add('hidden');
}

// Logout function
function logout() {
    if (confirm('Oturumu kapatmak istediğinizden emin misiniz?')) {
        fetch('auth/logout.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Hide user profile, show guest buttons
                document.getElementById('user-profile').style.display = 'none';
                document.getElementById('guest-buttons').style.display = '';
                
                // Clear user data
                document.getElementById('user-name').textContent = '';
                document.getElementById('dropdown-name').textContent = '';
                document.getElementById('dropdown-email').textContent = '';
                
                // Redirect to home page
                window.location.href = 'index.php';
            }
        })
        .catch(error => {
            console.error('Logout error:', error);
            // Force logout on client side
            document.getElementById('user-profile').style.display = 'none';
            document.getElementById('guest-buttons').style.display = '';
            window.location.href = 'index.php';
        });
    }
}

// Mobile menu controls
function toggleMobileMenu() {
    const menu = document.getElementById('mobile-menu');
    const overlay = document.getElementById('mobile-menu-overlay');
    const btn = document.getElementById('mobile-menu-button');
    if (!menu || !overlay) return;
    const isHidden = menu.classList.contains('-translate-x-full');
    // Show
    if (isHidden) {
        menu.classList.remove('-translate-x-full');
        overlay.classList.remove('hidden');
        if (btn) btn.setAttribute('aria-expanded', 'true');
    } else {
        // Hide
        menu.classList.add('-translate-x-full');
        overlay.classList.add('hidden');
        if (btn) btn.setAttribute('aria-expanded', 'false');
    }
}

function closeMobileMenu() {
    const menu = document.getElementById('mobile-menu');
    const overlay = document.getElementById('mobile-menu-overlay');
    const btn = document.getElementById('mobile-menu-button');
    if (menu) menu.classList.add('-translate-x-full');
    if (overlay && !overlay.classList.contains('hidden')) overlay.classList.add('hidden');
    if (btn) btn.setAttribute('aria-expanded', 'false');
}

// Mobile drawer section toggles
function toggleMobileSection(key) {
    const content = document.getElementById(`mobile-sec-${key}`);
    if (!content) return;

    // Determine current visibility (accounts for hidden attribute and class)
    const isCurrentlyHidden = content.hasAttribute('hidden') || content.classList.contains('hidden') || content.style.display === 'none';

    // Collapse all other sections
    ['trading','portfolio','invest','services','help'].forEach(k => {
        const el = document.getElementById(`mobile-sec-${k}`);
        if (!el) return;
        if (el !== content) {
            el.setAttribute('hidden', '');
            el.classList.add('hidden');
            // Update corresponding trigger aria-expanded=false
            const trigger = document.querySelector(`[aria-controls="mobile-sec-${k}"]`);
            if (trigger) trigger.setAttribute('aria-expanded', 'false');
        }
    });

    // Toggle selected section
    if (isCurrentlyHidden) {
        content.removeAttribute('hidden');
        content.classList.remove('hidden');
        const trigger = document.querySelector(`[aria-controls="mobile-sec-${key}"]`);
        if (trigger) trigger.setAttribute('aria-expanded', 'true');
    } else {
        content.setAttribute('hidden', '');
        content.classList.add('hidden');
        const trigger = document.querySelector(`[aria-controls="mobile-sec-${key}"]`);
        if (trigger) trigger.setAttribute('aria-expanded', 'false');
    }
}

// Check login status on page load
document.addEventListener('DOMContentLoaded', function() {
    // Ensure mobile drawer starts closed on page load
    const menu = document.getElementById('mobile-menu');
    const overlay = document.getElementById('mobile-menu-overlay');
    const btn = document.getElementById('mobile-menu-button');
    if (menu && !menu.classList.contains('-translate-x-full')) {
        menu.classList.add('-translate-x-full');
    }
    if (overlay && !overlay.classList.contains('hidden')) {
        overlay.classList.add('hidden');
    }
    if (btn) btn.setAttribute('aria-expanded', 'false');

    // Check if user is logged in via session
    fetch('auth/check-login.php')
        .then(response => response.json())
        .then(data => {
            const guestButtons = document.getElementById('guest-buttons');
            const userProfile = document.getElementById('user-profile');
            const mobileGuest = document.getElementById('mobile-guest-buttons');
            const mobileUser = document.getElementById('mobile-user-profile');
            
            if (data.logged_in) {
                // Show user profile, hide guest buttons
                userProfile.style.display = 'block';
                guestButtons.style.display = 'none';
                
                // Update user info
                if (document.getElementById('user-name')) {
                    document.getElementById('user-name').textContent = data.user_name;
                }
                if (document.getElementById('dropdown-name')) {
                    document.getElementById('dropdown-name').textContent = data.user_name;
                }
                if (document.getElementById('dropdown-email')) {
                    document.getElementById('dropdown-email').textContent = data.user_email;
                }

                // Avatar
                const defaultAvatar = "data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='80' height='80'><rect width='100%' height='100%' fill='%23e5e7eb'/><text x='50%' y='52%' dominant-baseline='middle' text-anchor='middle' fill='%239ca3af' font-family='Arial' font-size='28'>👤</text></svg>";
                const avatarUrl = (data.user_avatar && data.user_avatar.trim() !== '') ? data.user_avatar : defaultAvatar;
                const headerAvatar = document.getElementById('user-avatar');
                const dropdownAvatar = document.getElementById('dropdown-avatar');
                if (headerAvatar) headerAvatar.src = avatarUrl;
                if (dropdownAvatar) dropdownAvatar.src = avatarUrl;

                // Mobile
                if (mobileGuest) mobileGuest.style.display = 'none';
                if (mobileUser) mobileUser.classList.remove('hidden');
                const mName = document.getElementById('mobile-user-name');
                const mEmail = document.getElementById('mobile-user-email');
                const mAvatar = document.getElementById('mobile-user-avatar');
                if (mName) mName.textContent = data.user_name || '';
                if (mEmail) mEmail.textContent = data.user_email || '';
                if (mAvatar) mAvatar.src = avatarUrl;
            } else {
                // Show guest buttons, hide user profile
                userProfile.style.display = 'none';
                guestButtons.style.display = '';
                if (mobileGuest) mobileGuest.style.display = '';
                if (mobileUser) mobileUser.classList.add('hidden');
            }
        })
        .catch(error => {
            console.error('Login check error:', error);
            // Default to guest view
            document.getElementById('guest-buttons').style.display = '';
            document.getElementById('user-profile').style.display = 'none';
            const mobileGuest = document.getElementById('mobile-guest-buttons');
            const mobileUser = document.getElementById('mobile-user-profile');
            if (mobileGuest) mobileGuest.style.display = '';
            if (mobileUser) mobileUser.classList.add('hidden');
        });
});

// Close dropdown when clicking outside
document.addEventListener('click', function(e) {
    const profileDropdown = document.getElementById('profile-dropdown');
    const profileButton = document.querySelector('#user-profile button');
    
    if (profileDropdown && !profileDropdown.contains(e.target) && (!profileButton || !profileButton.contains(e.target))) {
        closeProfileDropdown();
    }
});

// Register form AJAX submission
document.addEventListener('DOMContentLoaded', function() {
    const registerForm = document.getElementById('register-form-header');
    if (registerForm) {
        registerForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(registerForm);
            const submitButton = registerForm.querySelector('button[type="submit"]');
            const originalText = submitButton.innerHTML;
            
            // Loading state
            submitButton.disabled = true;
            submitButton.innerHTML = '<span>İşleniyor...</span>';
            
            fetch('auth/register.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Başarı mesajı
                    alert(data.message || 'Hesap başarıyla oluşturuldu!');
                    
                    // Modal'ı kapat
                    closeRegisterModal();
                    
                    // Sayfayı yenile veya yönlendir
                    if (data.redirect) {
                        window.location.href = data.redirect;
                    } else {
                        window.location.reload();
                    }
                } else {
                    // Hata mesajı
                    alert(data.message || 'Kayıt sırasında bir hata oluştu.');
                    submitButton.disabled = false;
                    submitButton.innerHTML = originalText;
                }
            })
            .catch(error => {
                console.error('Register error:', error);
                alert('Bir hata oluştu. Lütfen tekrar deneyin.');
                submitButton.disabled = false;
                submitButton.innerHTML = originalText;
            });
        });
    }
});
</script>
