<?php
session_start();
header('Content-Type: application/json');
if (!isset($_SESSION['user_id'])) { echo json_encode(['success'=>false,'message'=>'Giriş yapın.']); exit; }
require_once __DIR__ . '/../config/database.php';

$user_id = $_SESSION['user_id'];
$yield_id = intval($_POST['yield_id'] ?? 0);
if ($yield_id <= 0) { echo json_encode(['success'=>false,'message'=>'Geçersiz ID']); exit; }

try {
    $db = getDB();
    $db->beginTransaction();

    $stmt = $db->prepare('SELECT * FROM yields WHERE id=? AND user_id=? AND status=\'active\' FOR UPDATE');
    $stmt->execute([$yield_id,$user_id]);
    $y = $stmt->fetch();
    if (!$y) throw new Exception('Pozisyon bulunamadı');

    $r1 = floatval($y['rewards_1']);
    $r2 = floatval($y['rewards_2']);
    if ($r1<=0 && $r2<=0) throw new Exception('Toplanacak ödül yok');

    if ($r1>0) {
        $stmt = $db->prepare('UPDATE wallets SET available=available+?, balance=balance+? WHERE user_id=? AND coin_symbol=?');
        $stmt->execute([$r1,$r1,$user_id,$y['coin_symbol_1']]);
        $stmt = $db->prepare('INSERT INTO transactions (user_id,type,coin_symbol,amount,price,status,created_at) VALUES (\'$user_id\',\'yield_reward\',?,?,0,\'completed\',NOW())');
        $stmt->execute([$y['coin_symbol_1'],$r1]);
    }
    if ($r2>0) {
        $stmt = $db->prepare('UPDATE wallets SET available=available+?, balance=balance+? WHERE user_id=? AND coin_symbol=?');
        $stmt->execute([$r2,$r2,$user_id,$y['coin_symbol_2']]);
        $stmt = $db->prepare('INSERT INTO transactions (user_id,type,coin_symbol,amount,price,status,created_at) VALUES (\'$user_id\',\'yield_reward\',?,?,0,\'completed\',NOW())');
        $stmt->execute([$y['coin_symbol_2'],$r2]);
    }

    $stmt = $db->prepare('UPDATE yields SET rewards_1=0, rewards_2=0 WHERE id=?');
    $stmt->execute([$yield_id]);

    $db->commit();
    echo json_encode(['success'=>true,'message'=>'Ödüller toplandı']);
} catch (Throwable $e) {
    if ($db && $db->inTransaction()) $db->rollBack();
    echo json_encode(['success'=>false,'message'=>'Hata: '.$e->getMessage()]);
}
