<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Giriş yapmanız gerekiyor.']);
    exit;
}

require_once __DIR__ . '/../config/database.php';

$user_id = $_SESSION['user_id'];
$lending_id = intval($_POST['lending_id'] ?? 0);

if ($lending_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Geçerli lending ID giriniz.']);
    exit;
}

try {
    $db = getDB();
    $db->beginTransaction();

    $stmt = $db->prepare('SELECT * FROM lendings WHERE id = ? AND user_id = ? AND status = "active" FOR UPDATE');
    $stmt->execute([$lending_id, $user_id]);
    $lend = $stmt->fetch();
    if (!$lend) {
        throw new Exception('Lending pozisyonu bulunamadı.');
    }

    $amount = floatval($lend['amount']);
    $interest = floatval($lend['interest_earned']);
    $total = $amount + $interest;

    // Frozen'dan available'a taşı, balance'a ekle
    $stmt = $db->prepare('UPDATE wallets SET frozen = frozen - ?, available = available + ?, balance = balance + ? WHERE user_id = ? AND coin_symbol = ?');
    $stmt->execute([$amount, $total, $total, $user_id, $lend['coin_symbol']]);

    // Status kapat
    $stmt = $db->prepare('UPDATE lendings SET status = "closed" WHERE id = ?');
    $stmt->execute([$lending_id]);

    // İşlem kaydı
    $stmt = $db->prepare('INSERT INTO transactions (user_id, type, coin_symbol, amount, price, status, created_at) VALUES (?, "lend_withdraw", ?, ?, 0, "completed", NOW())');
    $stmt->execute([$user_id, $lend['coin_symbol'], $total]);

    $db->commit();

    echo json_encode(['success' => true, 'message' => "Pozisyon çekildi: {$total} {$lend['coin_symbol']}"]);
} catch (Throwable $e) {
    if ($db && $db->inTransaction()) $db->rollBack();
    echo json_encode(['success' => false, 'message' => 'Hata: ' . $e->getMessage()]);
}
