<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Giriş yapmanız gerekiyor.']);
    exit;
}

require_once '../config/database.php';

$user_id = $_SESSION['user_id'];
$stake_id = intval($_POST['stake_id'] ?? 0);

if ($stake_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Geçerli bir stake ID giriniz.']);
    exit;
}

try {
    $db = getDB();
    $db->beginTransaction();
    
    // Stake kaydını al
    $stmt = $db->prepare("SELECT * FROM stakes WHERE id = ? AND user_id = ?");
    $stmt->execute([$stake_id, $user_id]);
    $stake = $stmt->fetch();
    
    if (!$stake) {
        throw new Exception('Stake kaydı bulunamadı!');
    }
    
    // Lock süresi dolmuş mu kontrol et
    if (strtotime($stake['unlock_date']) > time()) {
        throw new Exception('Stake süresi henüz dolmamış! Unlock tarihi: ' . date('d.m.Y H:i', strtotime($stake['unlock_date'])));
    }
    
    // Bakiyeyi geri ver (frozen'dan available'a taşı)
    $stmt = $db->prepare("UPDATE wallets SET frozen = frozen - ?, available = available + ?, balance = balance + ? WHERE user_id = ? AND coin_symbol = ?");
    $total = $stake['amount'] + $stake['rewards'];
    $stmt->execute([$stake['amount'], $total, $total, $user_id, $stake['coin_symbol']]);
    
    // İşlem kaydı ekle
    $stmt = $db->prepare("INSERT INTO transactions (user_id, type, coin_symbol, amount, price, status, created_at) VALUES (?, 'unstake', ?, ?, 0, 'completed', NOW())");
    $stmt->execute([$user_id, $stake['coin_symbol'], $total]);
    
    // Stake durumunu güncelle
    $stmt = $db->prepare("UPDATE stakes SET status = 'completed' WHERE id = ?");
    $stmt->execute([$stake_id]);
    
    $db->commit();
    
    echo json_encode([
        'success' => true, 
        'message' => "{$stake['amount']} {$stake['coin_symbol']} başarıyla çekildi!" . ($stake['rewards'] > 0 ? " {$stake['rewards']} {$stake['coin_symbol']} ödül de eklendi!" : ''),
        'data' => [
            'amount' => $stake['amount'],
            'rewards' => $stake['rewards'],
            'coin_symbol' => $stake['coin_symbol']
        ]
    ]);
    
} catch (Exception $e) {
    $db->rollBack();
    echo json_encode(['success' => false, 'message' => 'Hata: ' . $e->getMessage()]);
}
?>
