<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Giriş yapmanız gerekiyor.']);
    exit;
}

require_once __DIR__ . '/../config/database.php';

$user_id = $_SESSION['user_id'];
$lending_id = intval($_POST['lending_id'] ?? 0);

if ($lending_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Geçerli lending ID giriniz.']);
    exit;
}

try {
    $db = getDB();
    $db->beginTransaction();

    $stmt = $db->prepare('SELECT * FROM lendings WHERE id = ? AND user_id = ? AND status = "active" FOR UPDATE');
    $stmt->execute([$lending_id, $user_id]);
    $lend = $stmt->fetch();
    if (!$lend) {
        throw new Exception('Lending pozisyonu bulunamadı.');
    }

    $interest = floatval($lend['interest_earned']);
    if ($interest <= 0) {
        throw new Exception('Toplanacak faiz bulunmamaktadır.');
    }

    // Faizi cüzdana ekle
    $stmt = $db->prepare('UPDATE wallets SET available = available + ?, balance = balance + ? WHERE user_id = ? AND coin_symbol = ?');
    $stmt->execute([$interest, $interest, $user_id, $lend['coin_symbol']]);

    // Faizi sıfırla
    $stmt = $db->prepare('UPDATE lendings SET interest_earned = 0 WHERE id = ?');
    $stmt->execute([$lending_id]);

    // İşlem kaydı
    $stmt = $db->prepare('INSERT INTO transactions (user_id, type, coin_symbol, amount, price, status, created_at) VALUES (?, "lend_interest", ?, ?, 0, "completed", NOW())');
    $stmt->execute([$user_id, $lend['coin_symbol'], $interest]);

    $db->commit();

    echo json_encode(['success' => true, 'message' => "Faiz toplandı: {$interest} {$lend['coin_symbol']}"]);
} catch (Throwable $e) {
    if ($db && $db->inTransaction()) $db->rollBack();
    echo json_encode(['success' => false, 'message' => 'Hata: ' . $e->getMessage()]);
}
