<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Giriş yapmanız gerekiyor.']);
    exit;
}

require_once '../config/database.php';

$user_id = $_SESSION['user_id'];
$stake_id = intval($_POST['stake_id'] ?? 0);

if ($stake_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Geçerli bir stake ID giriniz.']);
    exit;
}

try {
    $db = getDB();
    $db->beginTransaction();
    
    // Stake kaydını al
    $stmt = $db->prepare("SELECT * FROM stakes WHERE id = ? AND user_id = ? AND status = 'active'");
    $stmt->execute([$stake_id, $user_id]);
    $stake = $stmt->fetch();
    
    if (!$stake) {
        throw new Exception('Stake kaydı bulunamadı!');
    }
    
    if ($stake['rewards'] <= 0) {
        throw new Exception('Toplanacak ödül bulunmamaktadır!');
    }
    
    // Ödülü cüzdana ekle
    $stmt = $db->prepare("UPDATE wallets SET available = available + ?, balance = balance + ? WHERE user_id = ? AND coin_symbol = ?");
    $stmt->execute([$stake['rewards'], $stake['rewards'], $user_id, $stake['coin_symbol']]);
    
    // Stake'in ödülünü sıfırla
    $stmt = $db->prepare("UPDATE stakes SET rewards = 0 WHERE id = ?");
    $stmt->execute([$stake_id]);
    
    // İşlem kaydı ekle
    $stmt = $db->prepare("INSERT INTO transactions (user_id, type, coin_symbol, amount, price, status, created_at) VALUES (?, 'stake_reward', ?, ?, 0, 'completed', NOW())");
    $stmt->execute([$user_id, $stake['coin_symbol'], $stake['rewards']]);
    
    $db->commit();
    
    echo json_encode([
        'success' => true, 
        'message' => "{$stake['rewards']} {$stake['coin_symbol']} ödül toplandı!",
        'data' => [
            'rewards' => $stake['rewards'],
            'coin_symbol' => $stake['coin_symbol']
        ]
    ]);
    
} catch (Exception $e) {
    $db->rollBack();
    echo json_encode(['success' => false, 'message' => 'Hata: ' . $e->getMessage()]);
}
?>
