<?php
session_start();
require_once __DIR__ . '/../config/database.php';

// Eğer zaten admin giriş yapmışsa yönlendir
if (isset($_SESSION['admin_id'])) {
    header('Location: index.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    try {
        $db = getDB();

        // is_admin kolonu yoksa oluşturmayı deneyelim (idempotent)
        $db->exec("ALTER TABLE users ADD COLUMN IF NOT EXISTS is_admin TINYINT(1) NOT NULL DEFAULT 0");

        $stmt = $db->prepare("SELECT id, email, password, is_admin FROM users WHERE email = ? LIMIT 1");
        $stmt->execute([$email]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            if ((int)$user['is_admin'] === 1) {
                $_SESSION['admin_id'] = (int)$user['id'];
                $_SESSION['admin_email'] = $user['email'];
                // last_login güncelle
                try {
                    $upd = $db->prepare("UPDATE users SET last_login = NOW() WHERE id = ?");
                    $upd->execute([$user['id']]);
                } catch (Exception $e) {
                    // sessiz geç
                }
                header('Location: index.php');
                exit;
            }
            $error = 'Bu hesap için yönetici yetkisi bulunmuyor.';
        } else {
            $error = 'E-posta veya şifre hatalı.';
        }
    } catch (Exception $e) {
        $error = 'Sunucu hatası: ' . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Giriş</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 min-h-screen">
    <div class="container mx-auto flex h-screen w-full items-center justify-center px-4">
        <div class="rounded-lg border bg-white text-gray-900 shadow-sm w-full max-w-md">
            <div class="flex flex-col p-6 space-y-1">
                <h3 class="tracking-tight text-2xl font-bold text-center">Admin Panel</h3>
                <p class="text-sm text-gray-500 text-center">Yönetici hesabınıza giriş yapın</p>
            </div>
            <div class="p-6 pt-0">
                <?php if (!empty($error)): ?>
                    <div class="mb-4 text-sm text-red-600 bg-red-50 border border-red-200 rounded px-3 py-2"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>
                <form class="space-y-4" method="post" action="">
                    <div class="space-y-2">
                        <label class="text-sm font-medium leading-none" for="email">E-posta</label>
                        <input type="email" class="flex h-10 w-full rounded-md border border-gray-300 bg-white px-3 py-2 text-base shadow-sm placeholder:text-gray-400 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-blue-500 md:text-sm" id="email" placeholder="ornek@email.com" autocapitalize="none" autocomplete="email" autocorrect="off" required name="email">
                    </div>
                    <div class="space-y-2">
                        <label class="text-sm font-medium leading-none" for="password">Şifre</label>
                        <input type="password" class="flex h-10 w-full rounded-md border border-gray-300 bg-white px-3 py-2 text-base shadow-sm placeholder:text-gray-400 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-blue-500 md:text-sm" id="password" autocomplete="current-password" required name="password">
                    </div>
                    <button class="inline-flex items-center justify-center gap-2 rounded-md text-sm font-medium bg-blue-600 text-white hover:bg-blue-700 h-10 px-4 py-2 w-full">Giriş Yap</button>
                </form>
            </div>
        </div>
    </div>
</body>
</html>



