<?php
session_start();

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$adminEmail = $_SESSION['admin_email'] ?? 'admin';
require_once '../config/database.php';

$success_message = '';
$error_message = '';

// Sayfa kaydetme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $action = $_POST['action'];
    
    if ($action === 'save_page') {
        $page_id = $_POST['page_id'] ?? null;
        $slug = $_POST['slug'] ?? '';
        $title = $_POST['title'] ?? '';
        $content = $_POST['content'] ?? '';
        $is_active = isset($_POST['is_active']) ? 1 : 0;
        
        try {
            $db = getDB();
            
            if ($page_id) {
                // Güncelle
                $stmt = $db->prepare("UPDATE legal_pages SET slug = ?, title = ?, content = ?, is_active = ? WHERE id = ?");
                $stmt->execute([$slug, $title, $content, $is_active, $page_id]);
                $success_message = 'Sayfa başarıyla güncellendi!';
            } else {
                // Yeni sayfa ekle
                $stmt = $db->prepare("INSERT INTO legal_pages (slug, title, content, is_active) VALUES (?, ?, ?, ?)");
                $stmt->execute([$slug, $title, $content, $is_active]);
                $success_message = 'Sayfa başarıyla eklendi!';
            }
        } catch (Exception $e) {
            $error_message = 'Hata: ' . $e->getMessage();
        }
    }
}

// Sayfa silme
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    try {
        $db = getDB();
        $stmt = $db->prepare("DELETE FROM legal_pages WHERE id = ?");
        $stmt->execute([$_GET['delete']]);
        $success_message = 'Sayfa başarıyla silindi!';
    } catch (Exception $e) {
        $error_message = 'Hata: ' . $e->getMessage();
    }
}

// Tüm sayfaları çek
try {
    $db = getDB();
    $stmt = $db->prepare("SELECT * FROM legal_pages ORDER BY title");
    $stmt->execute();
    $pages = $stmt->fetchAll();
    
    // Düzenleme için seçilen sayfa
    $edit_page = null;
    if (isset($_GET['edit']) && is_numeric($_GET['edit'])) {
        $stmt = $db->prepare("SELECT * FROM legal_pages WHERE id = ?");
        $stmt->execute([$_GET['edit']]);
        $edit_page = $stmt->fetch();
    }
} catch (Exception $e) {
    $pages = [];
    $error_message = 'Veritabanı hatası: ' . $e->getMessage();
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yasal Sayfalar - Admin Panel</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body>
<div class="flex min-h-screen bg-muted/20">
    <!-- Sidebar -->
    <div class="h-full fixed max-lg:w-[calc(100vw-35px)] top-0 left-0 z-50 flex-col bg-gradient-to-b from-background to-muted/20 border-r hidden lg:block w-64">
        <div class="h-14 flex items-center px-4 border-b">
            <a class="flex items-center gap-2" href="index.php">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-gauge h-6 w-6 text-primary"><path d="m12 14 4-4"></path><path d="M3.34 19a10 10 0 1 1 17.32 0"></path></svg>
                <span class="font-semibold text-lg">Coin Platform</span>
            </a>
        </div>
        <div dir="ltr" class="max-h-[calc(100vh-100px)] overflow-auto">
            <div class="flex-1 overflow-auto py-4">
                <div class="py-2">
                    <div class="px-4 mb-2"><h2 class="text-xs font-semibold text-muted-foreground uppercase tracking-wider">Platform</h2></div>
                    <div class="space-y-1 px-2">
                        <a class="block" href="index.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 text-muted-foreground hover:bg-muted/50 hover:text-foreground">
                                <span class="mr-3 flex-shrink-0 text-muted-foreground group-hover:text-foreground">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-layout-dashboard h-4 w-4"><rect width="7" height="9" x="3" y="3" rx="1"></rect><rect width="7" height="5" x="14" y="3" rx="1"></rect><rect width="7" height="9" x="14" y="12" rx="1"></rect><rect width="7" height="5" x="3" y="16" rx="1"></rect></svg>
                                </span>
                                <span class="truncate">Genel Bakış</span>
                            </div>
                        </a>
                        <a class="block" href="coins.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 text-muted-foreground hover:bg-muted/50 hover:text-foreground">
                                <span class="mr-3 flex-shrink-0 text-muted-foreground group-hover:text-foreground">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-coins h-4 w-4"><circle cx="8" cy="8" r="6"></circle><path d="M18.09 10.37A6 6 0 1 1 10.34 18"></path><path d="M7 6h1v4"></path><path d="m16.71 13.88.7.71-2.82 2.82"></path></svg>
                                </span>
                                <span class="truncate">Coinler</span>
                            </div>
                        </a>
                    </div>
                </div>

                <div class="py-2 mt-2">
                    <div class="px-4 mb-2"><h2 class="text-xs font-semibold text-muted-foreground uppercase tracking-wider">Kullanıcılar ve İşlemler</h2></div>
                    <div class="space-y-1 px-2">
                        <a class="block" href="users.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 text-muted-foreground hover:bg-muted/50 hover:text-foreground">
                                <span class="mr-3 flex-shrink-0 text-muted-foreground group-hover:text-foreground">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-users h-4 w-4"><path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path><circle cx="9" cy="7" r="4"></circle><path d="M22 21v-2a4 4 0 0 0-3-3.87"></path><path d="M16 3.13a4 4 0 0 1 0 7.75"></path></svg>
                                </span>
                                <span class="truncate">Kullanıcılar</span>
                            </div>
                        </a>
                        <a class="block" href="deposits.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 text-muted-foreground hover:bg-muted/50 hover:text-foreground">
                                <span class="mr-3 flex-shrink-0 text-muted-foreground group-hover:text-foreground">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-credit-card h-4 w-4"><rect width="20" height="14" x="2" y="5" rx="2"></rect><line x1="2" x2="22" y1="10" y2="10"></line></svg>
                                </span>
                                <span class="truncate">Para Yatırma</span>
                            </div>
                        </a>
                        <a class="block" href="withdrawals.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 text-muted-foreground hover:bg-muted/50 hover:text-foreground">
                                <span class="mr-3 flex-shrink-0 text-muted-foreground group-hover:text-foreground">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-banknote h-4 w-4"><rect width="20" height="12" x="2" y="6" rx="2"></rect><circle cx="12" cy="12" r="2"></circle><path d="M6 12h.01M18 12h.01"></path></svg>
                                </span>
                                <span class="truncate">Çekim Talepleri</span>
                            </div>
                        </a>
                    </div>
                </div>

                <div class="py-2 mt-2">
                    <div class="px-4 mb-2"><h2 class="text-xs font-semibold text-muted-foreground uppercase tracking-wider">İçerik Yönetimi</h2></div>
                    <div class="space-y-1 px-2">
                        <a class="block" href="components.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 text-muted-foreground hover:bg-muted/50 hover:text-foreground">
                                <span class="mr-3 flex-shrink-0 text-muted-foreground group-hover:text-foreground">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-layout h-4 w-4"><rect width="18" height="18" x="3" y="3" rx="2" ry="2"></rect><line x1="3" x2="21" y1="9" y2="9"></line><line x1="9" x2="9" y1="21" y2="9"></line></svg>
                                </span>
                                <span class="truncate">Header & Footer</span>
                            </div>
                        </a>
                        <a class="block" href="legal_pages.php">
                            <div class="group flex items-center py-2.5 px-3 text-sm font-medium rounded-lg transition-all duration-200 bg-primary/10 text-primary shadow-sm">
                                <span class="mr-3 flex-shrink-0 text-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-file-text h-4 w-4"><path d="M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z"></path><path d="M14 2v4a2 2 0 0 0 2 2h4"></path><path d="M10 9H8"></path><path d="M16 13H8"></path><path d="M16 17H8"></path></svg>
                                </span>
                                <span class="truncate">Yasal Sayfalar</span>
                                <span class="ml-auto h-1.5 w-1.5 rounded-full bg-primary"></span>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="p-1 border-t">
            <a href="logout.php" class="flex w-full items-center px-3 py-2.5 text-sm font-medium rounded-lg text-red-600 hover:bg-red-50/50 transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-log-out mr-3 h-4 w-4"><path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path><polyline points="16 17 21 12 16 7"></polyline><line x1="21" x2="9" y1="12" y2="12"></line></svg>
                <span>Çıkış Yap</span>
            </a>
        </div>
    </div>

    <!-- Main Content -->
    <div class="flex-1 lg:ml-64">
        <header class="sticky top-0 z-40 w-full border-b bg-background/95 backdrop-blur supports-[backdrop-filter]:bg-background/60">
            <div class="flex h-14 items-center">
                <div class="flex items-center gap-2 lg:hidden pl-6">
                    <button class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium hover:bg-accent hover:text-accent-foreground h-9 w-9 md:hidden" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-menu h-5 w-5"><line x1="4" x2="20" y1="12" y2="12"></line><line x1="4" x2="20" y1="6" y2="6"></line><line x1="4" x2="20" y1="18" y2="18"></line></svg>
                        <span class="sr-only">Toggle Menu</span>
                    </button>
                </div>
                <div class="flex flex-1 items-center justify-between space-x-2 md:justify-end">
                    <div class="w-full flex-1 md:w-auto md:flex-none"></div>
                    <nav class="flex items-center gap-2 pr-6">
                        <span class="text-sm text-gray-600"><?php echo htmlspecialchars($adminEmail); ?></span>
                    </nav>
                </div>
            </div>
        </header>
        
        <main class="p-6">
            <!-- Header -->
            <div class="mb-6">
                <h1 class="text-3xl font-bold text-gray-800">Yasal Sayfalar Yönetimi</h1>
                <p class="text-gray-600 mt-2">Yardım Merkezi, İletişim, SSS, Gizlilik ve Hizmet Şartları sayfalarını düzenleyin</p>
            </div>
            
            <!-- Messages -->
            <?php if ($success_message): ?>
                <div class="mb-4 px-4 py-3 bg-green-100 border border-green-400 text-green-700 rounded-lg">
                    <?php echo htmlspecialchars($success_message); ?>
                </div>
            <?php endif; ?>
            
            <?php if ($error_message): ?>
                <div class="mb-4 px-4 py-3 bg-red-100 border border-red-400 text-red-700 rounded-lg">
                    <?php echo htmlspecialchars($error_message); ?>
                </div>
            <?php endif; ?>
            
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Sayfa Listesi -->
                <div class="lg:col-span-1">
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200">
                        <div class="p-4 border-b border-gray-200">
                            <h2 class="text-lg font-semibold text-gray-800">Sayfalar</h2>
                        </div>
                        <div class="p-4">
                            <a href="legal_pages.php?new=1" class="w-full mb-4 px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors text-sm flex items-center justify-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-plus"><path d="M5 12h14"></path><path d="M12 5v14"></path></svg>
                                Yeni Sayfa
                            </a>
                            <div class="space-y-2">
                                <?php foreach ($pages as $page): ?>
                                    <div class="flex items-center justify-between p-3 rounded-lg hover:bg-gray-50 <?php echo (isset($_GET['edit']) && $_GET['edit'] == $page['id']) ? 'bg-blue-50 border border-blue-200' : ''; ?>">
                                        <div class="flex-1">
                                            <a href="legal_pages.php?edit=<?php echo $page['id']; ?>" class="block">
                                                <div class="font-medium text-gray-800"><?php echo htmlspecialchars($page['title']); ?></div>
                                                <div class="text-xs text-gray-500"><?php echo htmlspecialchars($page['slug']); ?></div>
                                            </a>
                                        </div>
                                        <div class="flex items-center gap-2">
                                            <span class="px-2 py-1 text-xs rounded <?php echo $page['is_active'] ? 'bg-green-100 text-green-700' : 'bg-gray-100 text-gray-700'; ?>">
                                                <?php echo $page['is_active'] ? 'Aktif' : 'Pasif'; ?>
                                            </span>
                                            <a href="legal_pages.php?delete=<?php echo $page['id']; ?>" onclick="return confirm('Bu sayfayı silmek istediğinizden emin misiniz?')" class="text-red-600 hover:text-red-700">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-trash-2"><path d="M3 6h18"></path><path d="M19 6v14c0 1-1 2-2 2H7c-1 0-2-1-2-2V6"></path><path d="M8 6V4c0-1 1-2 2-2h4c1 0 2 1 2 2v2"></path></svg>
                                            </a>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Düzenleme Formu -->
                <div class="lg:col-span-2">
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200">
                        <div class="p-4 border-b border-gray-200">
                            <h2 class="text-lg font-semibold text-gray-800"><?php echo $edit_page ? 'Sayfa Düzenle' : (isset($_GET['new']) ? 'Yeni Sayfa Ekle' : 'Sayfa Seçin'); ?></h2>
                        </div>
                        <div class="p-6">
                            <?php if ($edit_page || isset($_GET['new'])): ?>
                                <form method="POST" action="">
                                    <input type="hidden" name="action" value="save_page">
                                    <?php if ($edit_page): ?>
                                        <input type="hidden" name="page_id" value="<?php echo $edit_page['id']; ?>">
                                    <?php endif; ?>
                                    
                                    <div class="space-y-4">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-2">Slug (URL)</label>
                                            <input type="text" name="slug" value="<?php echo htmlspecialchars($edit_page['slug'] ?? ''); ?>" required 
                                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" 
                                                   placeholder="ornek: help, contact, faq">
                                            <p class="text-xs text-gray-500 mt-1">URL için kullanılacak benzersiz kelime (örn: help, contact, faq)</p>
                                        </div>
                                        
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-2">Başlık</label>
                                            <input type="text" name="title" value="<?php echo htmlspecialchars($edit_page['title'] ?? ''); ?>" required 
                                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                                        </div>
                                        
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-2">İçerik (HTML)</label>
                                            <textarea name="content" rows="20" required 
                                                      class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 font-mono text-sm"
                                                      placeholder="HTML içerik buraya..."><?php echo htmlspecialchars($edit_page['content'] ?? ''); ?></textarea>
                                            <p class="text-xs text-gray-500 mt-1">HTML formatında içerik girebilirsiniz (h1, h2, p, ul, li, strong vb.)</p>
                                        </div>
                                        
                                        <div class="flex items-center">
                                            <input type="checkbox" name="is_active" id="is_active" <?php echo ($edit_page && $edit_page['is_active']) ? 'checked' : ''; ?> 
                                                   class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                                            <label for="is_active" class="ml-2 text-sm text-gray-700">Sayfa aktif (görünür)</label>
                                        </div>
                                        
                                        <div class="flex gap-2">
                                            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                                                <?php echo $edit_page ? 'Güncelle' : 'Kaydet'; ?>
                                            </button>
                                            <a href="legal_pages.php" class="px-6 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700 transition-colors text-center">
                                                İptal
                                            </a>
                                        </div>
                                    </div>
                                </form>
                            <?php else: ?>
                                <div class="text-center py-12 text-gray-500">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mx-auto mb-4 text-gray-400">
                                        <path d="M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z"></path><path d="M14 2v4a2 2 0 0 0 2 2h4"></path><path d="M10 9H8"></path><path d="M16 13H8"></path><path d="M16 17H8"></path>
                                    </svg>
                                    <p>Düzenlemek için bir sayfa seçin veya yeni sayfa ekleyin</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>
</body>
</html>

